/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.ArrayMath;
import JSci.maths.Complex;
import JSci.maths.EngineerMath;
import JSci.maths.FourierMath;
import JSci.maths.NMapping;
import JSci.maths.NumericalConstants;
import JSci.maths.wavelet.FWTCoef;
import JSci.maths.wavelet.FWTPacketCoef;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.splines.LinearSpline;

public class Signal
extends LinearSpline
implements NumericalConstants,
Cloneable {
    private Filter filterdual;
    static final double normalisation = 0.7071067811865475;
    private Double[] param;
    static final double epsilon = 1.0E-6;

    public Object clone() {
        Signal signal = (Signal)super.clone();
        if (this.filterdual != null) {
            signal.filterdual = this.filterdual;
        }
        if (this.param != null) {
            signal.param = new Double[this.param.length];
            System.arraycopy(signal.param, 0, this.param, 0, this.param.length);
        }
        return signal;
    }

    private Signal copy(double[] dArray) {
        if (this.filterdual != null) {
            if (this.param != null) {
                double[] dArray2 = new double[this.param.length];
                int n = 0;
                while (n < dArray2.length) {
                    dArray2[n] = this.param[n];
                    ++n;
                }
                return new Signal(this.filterdual, dArray, dArray2);
            }
            return new Signal(this.filterdual, dArray);
        }
        return new Signal(dArray);
    }

    public Signal() {
    }

    public Signal(double[] dArray) {
        super(dArray);
    }

    public Signal(Filter filter, double[] dArray, double[] dArray2) {
        super(dArray);
        this.filterdual = filter;
        int n = 0;
        while (n < dArray2.length) {
            this.param[n] = new Double(dArray2[n]);
            ++n;
        }
    }

    public Signal(Filter filter) {
        this.filterdual = filter;
    }

    public Signal(Filter filter, double[] dArray) {
        super(dArray);
        this.filterdual = filter;
    }

    public double[] getValues() {
        return this.interpolate(0);
    }

    public void setFilter(Filter filter) {
        this.filterdual = filter;
    }

    public void setParameter(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            this.param[n] = new Double(dArray[n]);
            ++n;
        }
    }

    public void setParameter(Double[] doubleArray) {
        this.param = doubleArray;
    }

    public void removeParameter() {
        this.param = null;
    }

    public void setLengthFromEnd(int n) {
        double[] dArray = ArrayMath.setLengthFromEnd((double[])this.evaluate(0), (int)n);
        this.setValues(dArray);
    }

    public void resample(int n) {
        double[] dArray = EngineerMath.resample((double[])this.evaluate(0), (int)n);
        this.setValues(dArray);
    }

    public void setLengthFromBeginning(int n) {
        double[] dArray = ArrayMath.setLengthFromBeginning((double[])this.evaluate(0), (int)n);
        this.setValues(dArray);
    }

    public void setData(double[] dArray) {
        this.setValues(dArray);
    }

    public FWTCoef fwt(int n) {
        if (n > 20) {
            throw new IllegalArgumentException("Too many iterations.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Cannot have a negative number of iterations.");
        }
        double[] dArray = this.interpolate(0);
        double[][] dArray2 = new double[n + 1][];
        int n2 = 1;
        while (n2 <= n) {
            dArray2[n2] = this.highpassProject(dArray);
            dArray = this.lowpassProject(dArray);
            ++n2;
        }
        dArray2[0] = dArray;
        FWTCoef fWTCoef = new FWTCoef(dArray2);
        return fWTCoef;
    }

    public FWTPacketCoef fwtPacket(int n, NMapping nMapping) {
        if (n > 20) {
            throw new IllegalArgumentException("Too many iterations.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Cannot have a negative number of iterations.");
        }
        double[] dArray = this.interpolate(0);
        double[][] dArray2 = new double[n + 1][];
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            double[] dArray3 = this.highpassProject(dArray);
            double[] dArray4 = this.lowpassProject(dArray);
            if (nMapping.map(dArray3)[0] < nMapping.map(dArray4)[0]) {
                dArray2[n2] = dArray3;
                dArray = dArray4;
                blArray[n2] = true;
            } else {
                dArray = dArray3;
                dArray2[n2] = dArray4;
                blArray[n2] = false;
            }
            ++n2;
        }
        dArray2[n] = dArray;
        FWTPacketCoef fWTPacketCoef = new FWTPacketCoef(dArray2, blArray);
        return fWTPacketCoef;
    }

    private double[] lowpassProject(double[] dArray) {
        int n = this.filterdual.previousDimension(dArray.length);
        double[] dArray2 = new double[n];
        if (this.param != null) {
            int n2 = 0;
            while (n2 < n) {
                double[] dArray3 = new double[this.param.length];
                int n3 = 0;
                while (n3 < dArray3.length) {
                    dArray3[n3] = this.param[n3];
                    ++n3;
                }
                double[] dArray4 = this.filterdual.lowpass(this.delta(n2, n, 0.7071067811865475), dArray3);
                dArray2[n2] = Signal.scalarProduct(dArray, dArray4);
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                double[] dArray5 = this.filterdual.lowpass(this.delta(n4, n, 0.7071067811865475));
                dArray2[n4] = Signal.scalarProduct(dArray, dArray5);
                ++n4;
            }
        }
        return dArray2;
    }

    private static double scalarProduct(double[] dArray, double[] dArray2) {
        double d = 0.0;
        int n = 0;
        while (n < dArray.length) {
            d += dArray[n] * dArray2[n];
            ++n;
        }
        return d;
    }

    public double[] lowpassProject() {
        double[] dArray = this.interpolate(0);
        return this.lowpassProject(dArray);
    }

    private double[] highpassProject(double[] dArray) {
        int n = this.filterdual.previousDimension(dArray.length);
        int n2 = dArray.length - n;
        double[] dArray2 = new double[n2];
        if (this.param != null) {
            int n3 = 0;
            while (n3 < n2) {
                double[] dArray3 = new double[this.param.length];
                int n4 = 0;
                while (n4 < dArray3.length) {
                    dArray3[n4] = this.param[n4];
                    ++n4;
                }
                double[] dArray4 = this.filterdual.highpass(this.delta(n3, n2, 1.0), dArray3);
                dArray2[n3] = Signal.scalarProduct(dArray, dArray4);
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                double[] dArray5 = this.filterdual.highpass(this.delta(n5, n2, 1.0));
                dArray2[n5] = Signal.scalarProduct(dArray, dArray5);
                ++n5;
            }
        }
        return dArray2;
    }

    public double[] highpassProject() {
        double[] dArray = this.interpolate(0);
        return this.highpassProject(dArray);
    }

    private double[] delta(int n, int n2, double d) {
        if (n < 0 || n > n2 || n2 < 0) {
            throw new IllegalArgumentException("This Kronecker doesn't exist.");
        }
        double[] dArray = new double[n2];
        dArray[n] = d;
        return dArray;
    }

    public double norm() {
        double[] dArray = this.interpolate(0);
        return Math.sqrt(ArrayMath.sumSquares((double[])dArray));
    }

    public Complex[] fft() {
        double[] dArray = this.interpolate(0);
        return FourierMath.transform((double[])dArray);
    }

    public static Complex[] fft(double[] dArray) {
        return FourierMath.transform((double[])dArray);
    }

    public static Complex[] fft(Complex[] complexArray) {
        return FourierMath.transform((Complex[])complexArray);
    }

    public double[] absFFT() {
        Complex[] complexArray = this.fft();
        double[] dArray = new double[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            dArray[n] = complexArray[n].mod();
            ++n;
        }
        return dArray;
    }

    public static double[] absFFT(double[] dArray) {
        Complex[] complexArray = FourierMath.transform((double[])dArray);
        double[] dArray2 = new double[complexArray.length];
        int n = 0;
        while (n < complexArray.length) {
            dArray2[n] = complexArray[n].mod();
            ++n;
        }
        return dArray2;
    }

    public static Complex[] fftInverse(Complex[] complexArray) {
        return FourierMath.inverseTransform((Complex[])complexArray);
    }

    private static int reverseBits(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 << 1 | n & 1;
            n >>= 1;
            ++n4;
        }
        return n3;
    }

    public boolean equals(Signal signal) {
        return ArrayMath.equals((double[])this.getValues(), (double[])signal.getValues());
    }

    public void setDimensionFromEnd(int n) {
        double[] dArray = this.interpolate(0);
        double[] dArray2 = new double[n];
        int n2 = n - dArray.length < 0 ? dArray.length - n : 0;
        int n3 = n2;
        while (n3 < dArray.length) {
            dArray2[n3 + n - dArray.length] = dArray[n3];
            ++n3;
        }
        super.setValues(dArray2);
    }

    public void setDimensionFromBeginning(int n) {
        double[] dArray = this.interpolate(0);
        double[] dArray2 = new double[n];
        int n2 = n - dArray.length < 0 ? dArray.length - n : 0;
        int n3 = 0;
        while (n3 < dArray.length - n2) {
            dArray2[n3] = dArray[n3];
            ++n3;
        }
        super.setValues(dArray2);
    }

    public void denoiseByFFT(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be 1 or more : " + n);
        }
        double[] dArray = this.interpolate(0);
        if (n > dArray.length - 2) {
            if (dArray.length < 4) {
                throw new IllegalArgumentException("Your signal is too short to be denoised : " + dArray.length + " < 4");
            }
            throw new IllegalArgumentException("Since you signal has dimension " + dArray.length + ", the parameter must be at most : " + (dArray.length - 2));
        }
        Complex[] complexArray = FourierMath.transform((double[])dArray);
        complexArray[n + 1] = Complex.ZERO;
        complexArray[dArray.length - 1 - n] = Complex.ZERO;
        Complex[] complexArray2 = FourierMath.inverseTransform((Complex[])complexArray);
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = complexArray2[n2].real();
            if (Math.abs(complexArray2[n2].imag()) > 1.0E-6) {
                throw new IllegalArgumentException("Complex values detected during synthesis. Please get in touch with Daniel Lemire at Daniel.Lemire@Tintin.net to report this error.");
            }
            ++n2;
        }
        super.setValues(dArray);
    }

    public double entropy() {
        return EngineerMath.entropy((double[])this.evaluate(0));
    }

    public Signal filter(double[] dArray) {
        double[] dArray2 = super.interpolate(0);
        if (dArray2.length - (dArray.length - 1) <= 0) {
            throw new IllegalArgumentException("Your signal is too short for this Filter : " + dArray2.length + ", " + dArray.length);
        }
        double[] dArray3 = new double[dArray2.length - (dArray.length - 1)];
        int n = 0;
        while (n < dArray2.length - (dArray.length - 1)) {
            int n2 = 0;
            while (n2 < dArray.length) {
                int n3 = n;
                dArray3[n3] = dArray3[n3] + dArray[n2] * dArray2[n + n2];
                ++n2;
            }
            ++n;
        }
        return this.copy(dArray3);
    }

    public Signal medianFilter(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter must be positive: " + n + " < 0");
        }
        double[] dArray = super.interpolate(0);
        if (dArray.length - 2 * n <= 0) {
            throw new IllegalArgumentException("Your signal is too short for this Filter : " + dArray.length + " - " + 2 * n + " = " + (dArray.length - 2 * n));
        }
        double[] dArray2 = new double[dArray.length - 2 * n];
        double[] dArray3 = new double[2 * n + 1];
        int n2 = 0;
        while (n2 < dArray.length - 2 * n) {
            int n3 = 0;
            while (n3 < 2 * n + 1) {
                dArray3[n3] = dArray[n2 + n3];
                ++n3;
            }
            dArray2[n2] = ArrayMath.percentile((double[])dArray3, (double)0.5);
            ++n2;
        }
        return this.copy(dArray2);
    }

    public Signal denoiseShortPeaks(double d, int n) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The parameter p must be between 0 and 1: " + d);
        }
        double[] dArray = this.interpolate(0);
        double d2 = ArrayMath.max((double[])dArray) - ArrayMath.min((double[])dArray);
        double d3 = d2 * d;
        double[] dArray2 = this.medianFilter(n).interpolate(0);
        int n2 = n;
        while (n2 < dArray.length - n) {
            if (Math.abs(dArray[n2] - dArray2[n2 - n]) > d3) {
                dArray[n2] = dArray2[n2 - n];
            }
            ++n2;
        }
        return this.copy(dArray);
    }
}

