/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet;

import JSci.maths.DoubleSparseVector;
import JSci.maths.DoubleVector;
import JSci.maths.wavelet.DiscreteFunction;
import JSci.util.VectorToolkit;

public class SparseDiscreteFunction
extends DiscreteFunction
implements Cloneable {
    public DoubleSparseVector Data;

    public SparseDiscreteFunction(double[] dArray) {
        this.setData(dArray);
    }

    public String toString() {
        return this.Data.toString();
    }

    public void normalize() {
        this.Data.normalize();
    }

    public void setData(double[] dArray) {
        this.Data = new DoubleSparseVector(dArray);
    }

    public double[] evaluate() {
        return VectorToolkit.toArray((DoubleVector)this.Data);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SparseDiscreteFunction) {
            SparseDiscreteFunction sparseDiscreteFunction = (SparseDiscreteFunction)object;
            return this.Data.equals((Object)sparseDiscreteFunction.Data);
        }
        return false;
    }

    public double[] evaluate(int n) {
        return this.evaluate();
    }

    public double mass(double d, double d2, int n) {
        return this.Data.mass() / (double)(this.Data.dimension() - 1) * Math.abs(d2 - d);
    }

    public double norm() {
        DoubleSparseVector doubleSparseVector = this.Data;
        return Math.sqrt(doubleSparseVector.sumSquares());
    }

    public double norm(int n) {
        DoubleSparseVector doubleSparseVector = this.Data;
        return Math.sqrt(doubleSparseVector.sumSquares());
    }

    public Object clone() {
        SparseDiscreteFunction sparseDiscreteFunction = (SparseDiscreteFunction)super.clone();
        sparseDiscreteFunction.Data = new DoubleSparseVector(VectorToolkit.toArray((DoubleVector)this.Data));
        return sparseDiscreteFunction;
    }

    public int dimension(int n) {
        return this.Data.dimension();
    }

    public int dimension() {
        return this.Data.dimension();
    }

    public int getFilterType() {
        return this.Data.dimension();
    }
}

