/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies2;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies2.Daubechies2;

public final class Scaling2
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies2 cdf = new Daubechies2();

    public Scaling2(int n, int n2) {
        this.setParameters(n, n2);
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Scaling2) {
            Scaling2 scaling2 = (Scaling2)object;
            return Cascades.dimension(this.n0, 0, 2) == Cascades.dimension(scaling2.n0, 0, 2) && this.k == scaling2.k;
        }
        return false;
    }

    public int getFilterType() {
        return 2;
    }

    public Scaling2() {
    }

    public void setParameters(int n, int n2) {
        if (n < 4) {
            throw new IllegalScalingException(n, 4);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Scaling2 scaling2 = (Scaling2)super.clone();
        scaling2.n0 = this.n0;
        scaling2.k = this.k;
        return scaling2;
    }

    public double[] evaluate(int n) {
        Daubechies2 daubechies2 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalScaling(daubechies2, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n, 2);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 0, 2);
    }

    public int position() {
        return this.k;
    }
}

