/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies6;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies6.Daubechies6;

public final class Scaling6
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies6 cdf = new Daubechies6();

    public Scaling6(int n, int n2) {
        this.setParameters(n, n2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Scaling6) {
            Scaling6 scaling6 = (Scaling6)object;
            return Cascades.dimension(this.n0, 0, 10) == Cascades.dimension(scaling6.n0, 0, 10) && this.k == scaling6.k;
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public Scaling6() {
    }

    public int getFilterType() {
        return 10;
    }

    public void setParameters(int n, int n2) {
        if (n < 20) {
            throw new IllegalScalingException(n, 20);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Scaling6 scaling6 = (Scaling6)super.clone();
        scaling6.n0 = this.n0;
        scaling6.k = this.k;
        return scaling6;
    }

    public double[] evaluate(int n) {
        Daubechies6 daubechies6 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalScaling(daubechies6, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n, 10);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 0, 10);
    }

    public int position() {
        return this.k;
    }
}

