/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies6;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies6.Daubechies6;

public final class Wavelet6
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies6 cdf = new Daubechies6();

    public Wavelet6(int n, int n2) {
        this.setParameters(n, n2);
    }

    public Wavelet6() {
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Wavelet6) {
            Wavelet6 wavelet6 = (Wavelet6)object;
            return Cascades.dimension(this.n0, 1, 10) == Cascades.dimension(wavelet6.n0, 1, 10) && this.k == wavelet6.k;
        }
        return false;
    }

    public int getFilterType() {
        return 10;
    }

    public void setParameters(int n, int n2) {
        if (n < 20) {
            throw new IllegalScalingException(n, 20);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Wavelet6 wavelet6 = (Wavelet6)super.clone();
        wavelet6.n0 = this.n0;
        wavelet6.k = this.k;
        return wavelet6;
    }

    public double[] evaluate(int n) {
        Daubechies6 daubechies6 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalWavelet(daubechies6, 10, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n + 1, 10);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 1, 10);
    }

    public int position() {
        return this.k;
    }
}

