/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies7;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies7.Daubechies7;

public final class Scaling7
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies7 cdf = new Daubechies7();

    public Scaling7(int n, int n2) {
        this.setParameters(n, n2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Scaling7) {
            Scaling7 scaling7 = (Scaling7)object;
            return Cascades.dimension(this.n0, 0, 12) == Cascades.dimension(scaling7.n0, 0, 12) && this.k == scaling7.k;
        }
        return false;
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public Scaling7() {
    }

    public int getFilterType() {
        return 12;
    }

    public void setParameters(int n, int n2) {
        if (n < 24) {
            throw new IllegalScalingException(n, 24);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Scaling7 scaling7 = (Scaling7)super.clone();
        scaling7.n0 = this.n0;
        scaling7.k = this.k;
        return scaling7;
    }

    public double[] evaluate(int n) {
        Daubechies7 daubechies7 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalScaling(daubechies7, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n, 12);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 0, 12);
    }

    public int position() {
        return this.k;
    }
}

