/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.daubechies8;

import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.IllegalScalingException;
import JSci.maths.wavelet.MultiscaleFunction;
import JSci.maths.wavelet.daubechies8.Daubechies8;

public final class Scaling8
extends MultiscaleFunction
implements Cloneable {
    private int n0;
    private int k;
    private static final Daubechies8 cdf = new Daubechies8();

    public Scaling8(int n, int n2) {
        this.setParameters(n, n2);
    }

    public String toString() {
        String string = new String("[n0=");
        string.concat(Integer.toString(this.n0));
        string.concat("][k=");
        string.concat(Integer.toString(this.k));
        string.concat("]");
        return string;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Scaling8) {
            Scaling8 scaling8 = (Scaling8)object;
            return Cascades.dimension(this.n0, 0, 14) == Cascades.dimension(scaling8.n0, 0, 14) && this.k == scaling8.k;
        }
        return false;
    }

    public Scaling8() {
    }

    public int getFilterType() {
        return 14;
    }

    public void setParameters(int n, int n2) {
        if (n < 28) {
            throw new IllegalScalingException(n, 28);
        }
        this.n0 = n;
        this.k = n2;
    }

    public Object clone() {
        Scaling8 scaling8 = (Scaling8)super.clone();
        scaling8.n0 = this.n0;
        scaling8.k = this.k;
        return scaling8;
    }

    public double[] evaluate(int n) {
        Daubechies8 daubechies8 = cdf;
        int n2 = this.n0;
        int n3 = this.k;
        return Cascades.evalScaling(daubechies8, n2, n, n3);
    }

    public int dimension(int n) {
        return Cascades.dimension(this.n0, n, 14);
    }

    public int dimension() {
        return Cascades.dimension(this.n0, 0, 14);
    }

    public int position() {
        return this.k;
    }
}

