/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.haar;

import JSci.maths.wavelet.FWT;

public class FastHaar
extends FWT {
    static final float[] scale = new float[]{(float)(1.0 / Math.sqrt(2.0)), (float)(1.0 / Math.sqrt(2.0))};
    static final float[] wavelet = new float[]{-scale[1], scale[0]};

    private static void transform(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        int n2 = n / 2;
        try {
            int n3 = 0;
            while (true) {
                fArray2[n3 + n2] = fArray[2 * n3] * wavelet[0] + fArray[2 * n3 + 1] * wavelet[1];
                fArray2[n3] = fArray[2 * n3] * scale[0] + fArray[2 * n3 + 1] * scale[1];
                ++n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.arraycopy(fArray2, 0, fArray, 0, n);
            return;
        }
    }

    public void transform(float[] fArray) {
        int n = fArray.length;
        while (n > 2) {
            FastHaar.transform(fArray, n);
            n /= 2;
        }
        if (n != 2) {
            System.err.println("Careful! this should be a power of 2 : " + fArray.length);
        }
    }

    public void invTransform(float[] fArray) {
        int n = 2;
        while (2 * n <= fArray.length) {
            FastHaar.invTransform(fArray, n);
            n *= 2;
        }
        if (n != fArray.length) {
            System.err.println("Careful! this should be a power of 2 : " + fArray.length);
        }
    }

    private static void invTransform(float[] fArray, int n) {
        int n2 = 2 * n;
        float[] fArray2 = new float[n2];
        try {
            int n3 = 0;
            while (true) {
                int n4 = 2 * n3 + 1;
                fArray2[n4] = fArray2[n4] + (scale[1] * fArray[n3] + wavelet[1] * fArray[n3 + n]);
                int n5 = 2 * n3;
                fArray2[n5] = fArray2[n5] + (scale[0] * fArray[n3] + wavelet[0] * fArray[n3 + n]);
                ++n3;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
            return;
        }
    }
}

