/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.wavelet.splines;

import JSci.maths.ArrayMath;
import JSci.maths.wavelet.Cascades;
import JSci.maths.wavelet.Filter;
import JSci.maths.wavelet.splines.Spline;
import JSci.maths.wavelet.splines.SumOfDiracs;

public class PiecewiseConstant
extends Spline
implements Filter,
Cloneable {
    protected static final int filtretype = 0;
    private double[] vecteur;
    static final double[] vg = new double[]{1.0, 1.0};

    public String toString() {
        return ArrayMath.toString((double[])this.vecteur);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PiecewiseConstant && this.vecteur.length == ((PiecewiseConstant)object).dimension()) {
            PiecewiseConstant piecewiseConstant = (PiecewiseConstant)object;
            int n = 0;
            while (n < this.vecteur.length) {
                if (this.vecteur[n] != piecewiseConstant.getValue(n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int getFilterType() {
        return 0;
    }

    public int previousDimension(int n) {
        int n2 = (int)Math.round((double)n / 2.0);
        if (2 * n2 == n) {
            return n2;
        }
        throw new IllegalArgumentException("Odd number of values into an even Filter.");
    }

    public double[] lowpass(double[] dArray, double[] dArray2) {
        return this.lowpass(dArray);
    }

    public double[] highpass(double[] dArray, double[] dArray2) {
        return this.highpass(dArray);
    }

    public double[] lowpass(double[] dArray) {
        if (dArray.length < 1) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 1");
        }
        double[] dArray2 = new double[2 * dArray.length];
        int n = 0;
        while (n < dArray.length) {
            int n2 = 2 * n;
            dArray2[n2] = dArray2[n2] + dArray[n] * vg[0];
            int n3 = 2 * n + 1;
            dArray2[n3] = dArray2[n3] + dArray[n] * vg[1];
            ++n;
        }
        return dArray2;
    }

    public double[] highpass(double[] dArray) {
        if (dArray.length < 2) {
            throw new IllegalArgumentException("The array is not long enough : " + dArray.length + " < 2");
        }
        double[] dArray2 = Cascades.doublesample(dArray);
        int n = dArray2.length - 1;
        double[] dArray3 = new double[2 * dArray.length];
        double[] dArray4 = new double[]{-1.0, 1.0};
        int n2 = 0;
        while (n2 <= n - 1) {
            dArray3[n2] = ArrayMath.scalarProduct((double[])ArrayMath.extract((int)n2, (int)(n2 + 1), (double[])dArray2), (double[])dArray4);
            ++n2;
        }
        dArray3[n] = ArrayMath.scalarProduct((double[])ArrayMath.extract((int)(n - dArray4.length + 2), (int)n, (double[])dArray2), (double[])ArrayMath.extract((int)0, (int)(dArray4.length - 2), (double[])dArray4));
        return dArray3;
    }

    public PiecewiseConstant(double[] dArray) {
        this.vecteur = dArray;
    }

    public PiecewiseConstant() {
    }

    public Object clone() {
        PiecewiseConstant piecewiseConstant = (PiecewiseConstant)super.clone();
        if (this.vecteur != null) {
            piecewiseConstant.vecteur = ArrayMath.copy((double[])this.vecteur);
        }
        return piecewiseConstant;
    }

    public double getValue(int n) {
        if (n < 0 || n > this.vecteur.length - 1) {
            throw new IllegalArgumentException("Incorrect parameters : " + n + ", " + this.vecteur.length);
        }
        return this.vecteur[n];
    }

    public void setValues(double[] dArray) {
        this.vecteur = dArray;
    }

    public double mass(double d, double d2) {
        double d3 = 0.0;
        int n = 0;
        while (n < this.vecteur.length) {
            d3 += this.vecteur[n];
            ++n;
        }
        d3 = d3 * Math.abs(d2 - d) / (double)this.vecteur.length;
        return d3;
    }

    public void setValue(int n, double d) {
        if (n < 0) {
            throw new IllegalArgumentException("The parameter must be positive : " + n + " < 0");
        }
        this.vecteur[n] = d;
    }

    public SumOfDiracs derive() {
        return this.derive(0.0, 1.0);
    }

    public SumOfDiracs derive(double d, double d2) {
        double[] dArray = new double[this.vecteur.length + 1];
        int n = 1;
        while (n < this.vecteur.length) {
            dArray[n] = (this.vecteur[n] - this.vecteur[n - 1]) * (double)this.vecteur.length / Math.abs(d2 - d);
            ++n;
        }
        dArray[0] = 0.0;
        dArray[this.vecteur.length] = 0.0;
        SumOfDiracs sumOfDiracs = new SumOfDiracs(dArray);
        return sumOfDiracs;
    }

    public int dimension() {
        return this.vecteur.length + 1;
    }

    public int dimension(int n) {
        return Cascades.dimensionHaar(this.vecteur.length, n);
    }

    public double[] interpolate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("This parameter must be postive : " + n);
        }
        return Cascades.evaluation(this, n, this.vecteur);
    }

    public double[] evaluate(int n) {
        return this.interpolate(n);
    }
}

