/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.CategoryGraph2D;
import JSci.awt.CategoryGraph2DModel;
import JSci.awt.GraphDataEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public class BarGraph
extends CategoryGraph2D {
    private Color[] lineColor = new Color[]{Color.black, Color.blue, Color.green, Color.red, Color.yellow, Color.cyan, Color.lightGray, Color.magenta, Color.orange, Color.pink};
    private Point origin;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private float xScale;
    private float yScale;
    private final int scalePad = 5;
    private final int axisPad = 50;
    private boolean numbering = true;

    public BarGraph(CategoryGraph2DModel categoryGraph2DModel) {
        super(categoryGraph2DModel);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        float f;
        this.model.firstSeries();
        this.maxY = 0.0f;
        this.minY = 0.0f;
        this.minX = 0.0f;
        this.maxX = this.model.seriesLength();
        int n = 0;
        while (n < this.model.seriesLength()) {
            f = this.model.getValue(n);
            if (f > this.maxY) {
                this.maxY = f;
            } else if (f < this.minY) {
                this.minY = f;
            }
            ++n;
        }
        while (this.model.nextSeries()) {
            int n2 = 0;
            while (n2 < this.model.seriesLength()) {
                f = this.model.getValue(n2);
                if (f > this.maxY) {
                    this.maxY = f;
                } else if (f < this.minY) {
                    this.minY = f;
                }
                ++n2;
            }
        }
        if (this.maxY == this.minY) {
            this.maxY = 1.0f;
        }
        this.rescale();
    }

    public void setNumbering(boolean bl) {
        this.numbering = bl;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(250, 250);
    }

    protected void offscreenPaint(Graphics graphics) {
        int n;
        Point point;
        graphics.setColor(Color.black);
        graphics.drawLine(50, this.origin.y, this.getSize().width - 50, this.origin.y);
        graphics.drawLine(this.origin.x, 50, this.origin.x, this.getSize().height - 50);
        int n2 = 0;
        this.model.firstSeries();
        graphics.setColor(this.lineColor[n2]);
        int n3 = 0;
        while (n3 < this.model.seriesLength()) {
            point = this.model.getValue(n3) < 0.0f ? this.dataToScreen(n3, 0.0f) : this.dataToScreen(n3, this.model.getValue(n3));
            graphics.drawRect(point.x, point.y, Math.round(this.xScale), Math.abs(Math.round(this.yScale * this.model.getValue(n3))));
            ++n3;
        }
        while (this.model.nextSeries()) {
            graphics.setColor(this.lineColor[++n2]);
            n = 0;
            while (n < this.model.seriesLength()) {
                point = this.model.getValue(n) < 0.0f ? this.dataToScreen(n, 0.0f) : this.dataToScreen(n, this.model.getValue(n));
                graphics.drawRect(point.x, point.y, Math.round(this.xScale), Math.abs(Math.round(this.yScale * this.model.getValue(n))));
                ++n;
            }
        }
        graphics.setColor(Color.black);
        int n4 = graphics.getFontMetrics().getHeight();
        int n5 = 0;
        while (n5 < this.model.seriesLength()) {
            n = graphics.getFontMetrics().stringWidth(this.model.getCategory(n5));
            graphics.drawString(this.model.getCategory(n5), this.dataToScreen((float)((float)n5 + 0.5f - 0.5f * (float)n / this.xScale), (float)0.0f).x, this.origin.y + n4);
            ++n5;
        }
        if (this.numbering) {
            String string;
            float f;
            float f2 = f = this.round(40.0f / this.yScale);
            while (f2 <= this.maxY) {
                string = String.valueOf(this.round(f2));
                n = graphics.getFontMetrics().stringWidth(string);
                point = this.dataToScreen(0.0f, f2);
                graphics.drawLine(point.x, point.y, point.x - 5, point.y);
                graphics.drawString(string, this.origin.x - n - 8, point.y + n4 / 4);
                f2 += f;
            }
            f2 = -f;
            while (f2 >= this.minY) {
                string = String.valueOf(this.round(f2));
                n = graphics.getFontMetrics().stringWidth(string);
                point = this.dataToScreen(0.0f, f2);
                graphics.drawLine(point.x, point.y, point.x - 5, point.y);
                graphics.drawString(string, this.origin.x - n - 8, point.y + n4 / 4);
                f2 -= f;
            }
        }
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    private final void rescale() {
        Dimension dimension = this.getMinimumSize();
        int n = Math.max(this.getSize().width, dimension.width);
        int n2 = Math.max(this.getSize().height, dimension.height);
        this.xScale = (float)(n - 110) / (this.maxX - this.minX);
        this.yScale = (float)(n2 - 110) / (this.maxY - this.minY);
        this.origin = new Point(Math.round(-this.minX * this.xScale) + 50 + 5, Math.round(this.maxY * this.yScale) + 50 + 5);
        this.redraw();
    }

    private final Point dataToScreen(float f, float f2) {
        return new Point(this.origin.x + Math.round(this.xScale * f), this.origin.y - Math.round(this.yScale * f2));
    }
}

