/*
 * Decompiled with CFR 0.152.
 */
package JSci.awt;

import JSci.awt.AbstractGraphModel;
import JSci.awt.DataSeries;
import JSci.awt.Graph2DModel;
import java.util.Vector;

public final class DefaultGraph2DModel
extends AbstractGraphModel
implements Graph2DModel {
    private float[] xAxis;
    private final Vector series = new Vector();
    private int pos;
    private DataSeries curSeries;

    public void setXAxis(float[] fArray) {
        this.xAxis = new float[fArray.length];
        System.arraycopy(fArray, 0, this.xAxis, 0, fArray.length);
        this.fireDataChanged();
    }

    public void setXAxis(double[] dArray) {
        this.xAxis = new float[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            this.xAxis[n] = (float)dArray[n];
            ++n;
        }
        this.fireDataChanged();
    }

    public void setXAxis(float f, float f2, int n) {
        this.xAxis = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this.xAxis[n2] = (f2 - f) * (float)n2 / (float)(n - 1) + f;
            ++n2;
        }
        this.fireDataChanged();
    }

    public float[] getXAxis() {
        return this.xAxis;
    }

    public void addSeries(float[] fArray) {
        this.series.addElement(new DataSeries(fArray));
        this.fireDataChanged();
    }

    public void addSeries(double[] dArray) {
        this.series.addElement(new DataSeries(dArray));
        this.fireDataChanged();
    }

    public void changeSeries(int n, float[] fArray) {
        this.series.setElementAt(new DataSeries(fArray), n);
        this.fireDataChanged();
    }

    public void changeSeries(int n, double[] dArray) {
        this.series.setElementAt(new DataSeries(dArray), n);
        this.fireDataChanged();
    }

    public void removeSeries(int n) {
        this.series.removeElementAt(n);
        this.fireDataChanged();
    }

    public float[] getSeries(int n) {
        return ((DataSeries)this.series.elementAt(n)).getData();
    }

    public void setSeriesVisible(int n, boolean bl) {
        ((DataSeries)this.series.elementAt(n)).setVisible(bl);
        this.fireDataChanged();
    }

    public float getXCoord(int n) {
        return this.xAxis[n];
    }

    public float getYCoord(int n) {
        return this.curSeries.getValueAt(n);
    }

    public int seriesLength() {
        return this.curSeries.length();
    }

    public void firstSeries() {
        this.curSeries = (DataSeries)this.series.elementAt(0);
        this.pos = 0;
        while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1) {
            this.curSeries = (DataSeries)this.series.elementAt(++this.pos);
        }
    }

    public boolean nextSeries() {
        if (this.pos == this.series.size() - 1) {
            return false;
        }
        do {
            this.curSeries = (DataSeries)this.series.elementAt(++this.pos);
        } while (!this.curSeries.isVisible() && this.pos < this.series.size() - 1);
        return this.curSeries.isVisible();
    }
}

