/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.ColorScheme;
import JSci.swing.JDoubleBufferedComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public final class JContourPlot
extends JDoubleBufferedComponent
implements ColorScheme {
    private float[][] data;
    private double min;
    private double max;
    private int deltay;
    private ColorScheme CS = this;
    private double[] deltax;
    private float c1 = 1.0f;
    private float c2 = 1.0f;
    private float c3 = 1.0f;
    private int Contourx = 2;
    private int Contoury = 2;
    private int largeurMax;
    private int hauteurMax;
    private int ColorScaleWidth = 40;
    private String MaxString;
    private String MinString;
    private String MiddleString;

    public JContourPlot(double[][] dArray) {
        this.setBackground(Color.white);
        this.setData(dArray);
        this.setContourX(1);
        this.setContourY(1);
    }

    public void setData(double[][] dArray) {
        int n;
        double[][] dArray2 = new double[dArray.length][];
        int n2 = 0;
        while (n2 < dArray2.length) {
            dArray2[n2] = dArray[dArray2.length - n2 - 1];
            ++n2;
        }
        this.min = dArray2[0][0];
        this.max = dArray2[0][0];
        this.data = new float[dArray2.length][];
        int n3 = 0;
        while (n3 < dArray2.length) {
            this.data[n3] = new float[dArray2[n3].length];
            n = 0;
            while (n < dArray2[n3].length) {
                if (dArray2[n3][n] > this.max) {
                    this.max = dArray2[n3][n];
                }
                if (dArray2[n3][n] < this.min) {
                    this.min = dArray2[n3][n];
                }
                ++n;
            }
            ++n3;
        }
        if (this.max == this.min) {
            n = 0;
            while (n < dArray2.length) {
                int n4 = 0;
                while (n4 < dArray2[n].length) {
                    this.data[n][n4] = 1.0f;
                    ++n4;
                }
                ++n;
            }
        } else {
            int n5 = 0;
            while (n5 < dArray2.length) {
                int n6 = 0;
                while (n6 < dArray2[n5].length) {
                    Double d = new Double(1.0 - (dArray2[n5][n6] - this.min) / (this.max - this.min));
                    this.data[n5][n6] = d.floatValue();
                    ++n6;
                }
                ++n5;
            }
        }
        int n7 = this.getPrecision(this.max - this.min);
        this.MaxString = Double.toString(this.round(this.max, n7));
        this.MinString = Double.toString(this.round(this.min, n7));
        this.MiddleString = Double.toString(this.round((this.max + this.min) / 2.0, n7));
        this.rescale();
    }

    /*
     * Unable to fully structure code
     */
    private int getPrecision(double var1_1) {
        var1_1 = Math.abs(var1_1);
        var3_2 = 0;
        var4_3 = 1.0;
        if (!(var1_1 < 1.0)) ** GOTO lbl12
        while (var4_3 > var1_1) {
            var4_3 /= 10.0;
            --var3_2;
        }
        return var3_2;
lbl-1000:
        // 1 sources

        {
            var4_3 *= 10.0;
            ++var3_2;
lbl12:
            // 2 sources

            ** while (var4_3 < var1_1)
        }
lbl13:
        // 1 sources

        return var3_2;
    }

    private double round(double d, int n) {
        if (d == 0.0) {
            return 0.0;
        }
        double d2 = d / Math.abs(d);
        d = Math.abs(d);
        if (n < 0) {
            int n2 = n;
            while (n2 < 0) {
                ++n2;
                d *= 10.0;
            }
            d = Math.round(d);
            while (n < 0) {
                ++n;
                d /= 10.0;
            }
            return d * d2;
        }
        int n3 = n;
        while (n3 < 0) {
            ++n3;
            d /= 10.0;
        }
        d = Math.round(d);
        while (n < 0) {
            ++n;
            d *= 10.0;
        }
        return d * d2;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        int n = this.data[0].length;
        int n2 = 1;
        while (n2 < this.data.length) {
            if (this.data[n2].length > n) {
                n = this.data[n2].length;
            }
            ++n2;
        }
        return new Dimension(n + 3 * this.Contourx + this.ColorScaleWidth + 5, Math.max(this.data.length * 2 + 2 * this.Contoury, 100));
    }

    public void setContourX(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be greater than 1 : " + n + " < 1");
        }
        this.Contourx = n;
    }

    public void setContourY(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("This parameter must be greater than 1 : " + n + " < 1");
        }
        this.Contoury = n;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    private void rescale() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Dimension dimension = this.getMinimumSize();
        n = Math.max(n, dimension.width);
        n2 = Math.max(n2, dimension.height);
        int n3 = n - 3 * this.Contourx;
        int n4 = n2 - 2 * this.Contoury - this.ColorScaleWidth;
        this.deltay = (int)Math.floor(n4 / this.data.length);
        this.hauteurMax = this.deltay * this.data.length;
        this.deltax = new double[this.data.length];
        this.largeurMax = 0;
        int n5 = this.data[0].length;
        int n6 = 1;
        while (n6 < this.data.length) {
            n5 = Math.max(this.data[n6].length, n5);
            ++n6;
        }
        int n7 = (int)Math.floor((double)n3 / (double)n5) * n5;
        int n8 = 0;
        while (n8 < this.data.length) {
            this.deltax[n8] = (double)n7 / (double)this.data[n8].length;
            this.largeurMax = Math.max(this.largeurMax, (int)Math.floor((double)this.data[n8].length * this.deltax[n8]));
            ++n8;
        }
        this.redraw();
    }

    public void setColor(float f, float f2, float f3) {
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f) {
            throw new IllegalArgumentException("Incorrect parameters : " + f + ", " + f2 + ", " + f3);
        }
        if (f + f2 + f3 == 0.0f) {
            throw new IllegalArgumentException("You have chosen black at the specified color. This would generate a completly black graph. Please choose another color.");
        }
        this.c1 = f;
        this.c2 = f2;
        this.c3 = f3;
    }

    public Color getColor(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Color are given for values between 0 and 1 : " + f);
        }
        return Color.getHSBColor(f, 1.0f, 1.0f);
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.CS = colorScheme;
    }

    protected void offscreenPaint(Graphics graphics) {
        int n = graphics.getFontMetrics(graphics.getFont()).getHeight();
        graphics.setColor(new Color(1.0f - this.c1, 1.0f - this.c2, 1.0f - this.c3));
        graphics.drawRect(this.Contourx + this.ColorScaleWidth, this.Contoury - 1, this.largeurMax, this.hauteurMax);
        graphics.drawRect(this.Contourx - 1, this.Contoury - 1, this.ColorScaleWidth, this.hauteurMax);
        graphics.setClip(this.Contourx, this.Contoury, this.ColorScaleWidth - 1, this.hauteurMax - 1);
        float f = 0.0f;
        while (f < (float)this.hauteurMax) {
            graphics.setColor(this.CS.getColor(f / (float)this.hauteurMax));
            graphics.fillRect(this.Contourx, this.Contoury + (int)Math.floor(f), this.ColorScaleWidth - 1, 2);
            f += (float)this.hauteurMax / 255.0f;
        }
        graphics.setColor(Color.black);
        graphics.drawString(this.MaxString, this.Contourx, n + this.Contoury);
        graphics.drawString(this.MiddleString, this.Contourx, this.Contoury + (int)Math.round((double)(this.hauteurMax + n) / 2.0));
        graphics.drawString(this.MinString, this.Contourx, this.hauteurMax - 1);
        graphics.setClip(2 * this.Contourx + this.ColorScaleWidth, this.Contoury, this.largeurMax - 1, this.hauteurMax - 1);
        int n2 = 0;
        while (n2 < this.data.length) {
            int n3 = 0;
            while (n3 < this.data[n2].length) {
                graphics.setColor(this.CS.getColor(this.data[n2][n3]));
                graphics.fillRect((int)Math.floor((double)n3 * this.deltax[n2]) + 2 * this.Contourx + this.ColorScaleWidth, n2 * this.deltay + this.Contoury, (int)Math.floor(((double)n3 + 1.0) * this.deltax[n2]) + this.Contourx, (n2 + 1) * this.deltay + this.Contoury);
                ++n3;
            }
            graphics.setColor(this.getBackground());
            graphics.fillRect((int)Math.floor((double)this.data[n2].length * this.deltax[n2]) + 2 * this.Contourx + this.ColorScaleWidth, n2 * this.deltay + this.Contoury, this.largeurMax - 1, (n2 + 1) * this.deltay + this.Contoury);
            ++n2;
        }
    }
}

