/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.Graph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.awt.GraphDataListener;
import JSci.swing.JDoubleBufferedComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public abstract class JGraph2D
extends JDoubleBufferedComponent
implements GraphDataListener {
    protected Graph2DModel model;
    private boolean numbering = true;
    protected Point origin;
    protected float minX;
    protected float minY;
    protected float maxX;
    protected float maxY;
    protected float xScale;
    protected float yScale;
    protected final int scalePad = 5;
    protected final int axisPad = 25;

    public JGraph2D(Graph2DModel graph2DModel) {
        this.model = graph2DModel;
        this.model.addGraphDataListener(this);
    }

    public final void setModel(Graph2DModel graph2DModel) {
        this.model.removeGraphDataListener(this);
        this.model = graph2DModel;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final Graph2DModel getModel() {
        return this.model;
    }

    public final void setNumbering(boolean bl) {
        this.numbering = bl;
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    protected final void rescale() {
        Dimension dimension = this.getMinimumSize();
        int n = Math.max(this.getWidth(), dimension.width);
        int n2 = Math.max(this.getHeight(), dimension.height);
        this.xScale = (float)(n - 60) / (this.maxX - this.minX);
        this.yScale = (float)(n2 - 60) / (this.maxY - this.minY);
        this.origin = new Point(Math.round(-this.minX * this.xScale) + 25 + 5, Math.round(this.maxY * this.yScale) + 25 + 5);
        this.redraw();
    }

    protected final Point dataToScreen(float f, float f2) {
        return new Point(this.origin.x + Math.round(this.xScale * f), this.origin.y - Math.round(this.yScale * f2));
    }

    protected final void drawAxes(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(25, this.origin.y, this.getWidth() - 25, this.origin.y);
        graphics.drawLine(this.origin.x, 25, this.origin.x, this.getHeight() - 25);
        if (this.numbering) {
            float f;
            Point point;
            int n;
            String string;
            float f2;
            int n2 = graphics.getFontMetrics().getHeight();
            float f3 = f2 = this.round(40.0f / this.xScale);
            while (f3 <= this.maxX) {
                string = String.valueOf(this.round(f3));
                n = graphics.getFontMetrics().stringWidth(String.valueOf('+') + string);
                point = this.dataToScreen(f3, 0.0f);
                graphics.drawLine(point.x, point.y, point.x, point.y + 5);
                graphics.drawString(string, point.x - n / 2, this.origin.y + n2 + 5);
                f3 += f2;
            }
            f3 = -f2;
            while (f3 >= this.minX) {
                string = String.valueOf(this.round(f3));
                n = graphics.getFontMetrics().stringWidth(string);
                point = this.dataToScreen(f3, 0.0f);
                graphics.drawLine(point.x, point.y, point.x, point.y + 5);
                graphics.drawString(string, point.x - n / 2, this.origin.y + n2 + 5);
                f3 -= f2;
            }
            float f4 = f = this.round(40.0f / this.yScale);
            while (f4 <= this.maxY) {
                string = String.valueOf(this.round(f4));
                n = graphics.getFontMetrics().stringWidth(string);
                point = this.dataToScreen(0.0f, f4);
                graphics.drawLine(point.x, point.y, point.x - 5, point.y);
                graphics.drawString(string, this.origin.x - n - 8, point.y + n2 / 4);
                f4 += f;
            }
            f4 = -f;
            while (f4 >= this.minY) {
                string = String.valueOf(this.round(f4));
                n = graphics.getFontMetrics().stringWidth(string);
                point = this.dataToScreen(0.0f, f4);
                graphics.drawLine(point.x, point.y, point.x - 5, point.y);
                graphics.drawString(string, this.origin.x - n - 8, point.y + n2 / 4);
                f4 -= f;
            }
        }
    }

    protected final float round(float f) {
        float f2;
        float f3;
        int n = 1;
        if (f < 0.0f) {
            n = -1;
        }
        if ((f3 = Math.abs(f)) < 1.0f) {
            float f4 = 10.0f * f3;
            int n2 = 1;
            while (f4 < 1.0f) {
                f4 *= 10.0f;
                ++n2;
            }
            f2 = (float)Math.pow(10.0, n2 + 2 - 1);
        } else {
            float f5 = f3 / 10.0f;
            int n3 = 1;
            while (f5 > 1.0f) {
                f5 /= 10.0f;
                ++n3;
            }
            f2 = (float)Math.pow(10.0, 2 - n3);
        }
        return (float)((double)n * Math.rint(f3 * f2) / (double)f2);
    }

    public abstract void dataChanged(GraphDataEvent var1);
}

