/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.Graph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.swing.JGraph2D;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public class JScatterGraph
extends JGraph2D {
    public JScatterGraph(Graph2DModel graph2DModel) {
        super(graph2DModel);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        this.maxY = 0.0f;
        this.minY = 0.0f;
        this.maxX = 0.0f;
        this.minX = 0.0f;
        this.model.firstSeries();
        int n = 0;
        while (n < this.model.seriesLength()) {
            float f = this.model.getXCoord(n);
            if (f > this.maxX) {
                this.maxX = f;
            } else if (f < this.minX) {
                this.minX = f;
            }
            float f2 = this.model.getYCoord(n);
            if (f2 > this.maxY) {
                this.maxY = f2;
            } else if (f2 < this.minY) {
                this.minY = f2;
            }
            ++n;
        }
        if (this.maxY == this.minY) {
            this.maxY = 1.0f;
        }
        this.rescale();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(250, 250);
    }

    protected void offscreenPaint(Graphics graphics) {
        this.drawAxes(graphics);
        this.model.firstSeries();
        int n = 0;
        while (n < this.model.seriesLength()) {
            Point point = this.dataToScreen(this.model.getXCoord(n), this.model.getYCoord(n));
            graphics.fillRect(point.x, point.y, 1, 1);
            ++n;
        }
    }
}

