/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexVector;
import JSci.maths.Double3Vector;
import JSci.maths.DoubleVector;
import JSci.maths.Integer3Vector;
import JSci.maths.Mapping;
import JSci.maths.MathVector;
import JSci.maths.VectorDimensionException;

public class Complex3Vector
extends ComplexVector {
    public Complex3Vector() {
        super(3);
    }

    public Complex3Vector(Complex complex, Complex complex2, Complex complex3) {
        super(3);
        this.vector[0] = complex;
        this.vector[1] = complex2;
        this.vector[2] = complex3;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Complex3Vector) {
            Complex3Vector complex3Vector = (Complex3Vector)object;
            return this.vector[0].equals(complex3Vector.vector[0]) && this.vector[1].equals(complex3Vector.vector[1]) && this.vector[2].equals(complex3Vector.vector[2]);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.vector[0]).append(',').append(this.vector[1]).append(',').append(this.vector[2]);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public DoubleVector real() {
        return new Double3Vector(this.vector[0].real(), this.vector[1].real(), this.vector[2].real());
    }

    public DoubleVector imag() {
        return new Double3Vector(this.vector[0].imag(), this.vector[1].imag(), this.vector[2].imag());
    }

    public Complex getComponent(int n) {
        if (n >= 0 && n < 3) {
            return this.vector[n];
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, Complex complex) {
        if (n >= 0 && n < 3) {
            this.vector[n] = complex;
            return;
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public int dimension() {
        return 3;
    }

    public double norm() {
        return Math.sqrt(this.vector[0].real() * this.vector[0].real() + this.vector[0].imag() * this.vector[0].imag() + this.vector[1].real() * this.vector[1].real() + this.vector[1].imag() * this.vector[1].imag() + this.vector[2].real() * this.vector[2].real() + this.vector[2].imag() * this.vector[2].imag());
    }

    public double infNorm() {
        double d = this.vector[0].mod();
        if (this.vector[1].mod() > d) {
            d = this.vector[1].mod();
        }
        if (this.vector[2].mod() > d) {
            d = this.vector[2].mod();
        }
        return d;
    }

    public ComplexVector conjugate() {
        return new Complex3Vector(this.vector[0].conjugate(), this.vector[1].conjugate(), this.vector[2].conjugate());
    }

    public MathVector add(MathVector mathVector) {
        if (mathVector instanceof Complex3Vector) {
            return this.add((Complex3Vector)mathVector);
        }
        if (mathVector instanceof Double3Vector) {
            return this.add((Double3Vector)mathVector);
        }
        if (mathVector instanceof Integer3Vector) {
            return this.add((Integer3Vector)mathVector);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public Complex3Vector add(Complex3Vector complex3Vector) {
        return new Complex3Vector(this.vector[0].add(complex3Vector.vector[0]), this.vector[1].add(complex3Vector.vector[1]), this.vector[2].add(complex3Vector.vector[2]));
    }

    public Complex3Vector add(Double3Vector double3Vector) {
        return new Complex3Vector(this.vector[0].addReal(double3Vector.vector[0]), this.vector[1].addReal(double3Vector.vector[1]), this.vector[2].addReal(double3Vector.vector[2]));
    }

    public Complex3Vector add(Integer3Vector integer3Vector) {
        return new Complex3Vector(this.vector[0].addReal(integer3Vector.vector[0]), this.vector[1].addReal(integer3Vector.vector[1]), this.vector[2].addReal(integer3Vector.vector[2]));
    }

    public MathVector subtract(MathVector mathVector) {
        if (mathVector instanceof Complex3Vector) {
            return this.subtract((Complex3Vector)mathVector);
        }
        if (mathVector instanceof Double3Vector) {
            return this.subtract((Double3Vector)mathVector);
        }
        if (mathVector instanceof Integer3Vector) {
            return this.subtract((Integer3Vector)mathVector);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public Complex3Vector subtract(Complex3Vector complex3Vector) {
        return new Complex3Vector(this.vector[0].subtract(complex3Vector.vector[0]), this.vector[1].subtract(complex3Vector.vector[1]), this.vector[2].subtract(complex3Vector.vector[2]));
    }

    public Complex3Vector subtract(Double3Vector double3Vector) {
        return new Complex3Vector(this.vector[0].subtractReal(double3Vector.vector[0]), this.vector[1].subtractReal(double3Vector.vector[1]), this.vector[2].subtractReal(double3Vector.vector[2]));
    }

    public Complex3Vector subtract(Integer3Vector integer3Vector) {
        return new Complex3Vector(this.vector[0].subtractReal(integer3Vector.vector[0]), this.vector[1].subtractReal(integer3Vector.vector[1]), this.vector[2].subtractReal(integer3Vector.vector[2]));
    }

    public ComplexVector scalarMultiply(Complex complex) {
        return new Complex3Vector(this.vector[0].multiply(complex), this.vector[1].multiply(complex), this.vector[2].multiply(complex));
    }

    public ComplexVector scalarMultiply(double d) {
        return new Complex3Vector(this.vector[0].multiply(d), this.vector[1].multiply(d), this.vector[2].multiply(d));
    }

    public ComplexVector scalarDivide(Complex complex) {
        return new Complex3Vector(this.vector[0].divide(complex), this.vector[1].divide(complex), this.vector[2].divide(complex));
    }

    public ComplexVector scalarDivide(double d) {
        return new Complex3Vector(this.vector[0].divide(d), this.vector[1].divide(d), this.vector[2].divide(d));
    }

    public Complex scalarProduct(Complex3Vector complex3Vector) {
        return new Complex(this.vector[0].real() * complex3Vector.vector[0].real() + this.vector[0].imag() * complex3Vector.vector[0].imag() + this.vector[1].real() * complex3Vector.vector[1].real() + this.vector[1].imag() * complex3Vector.vector[1].imag() + this.vector[2].real() * complex3Vector.vector[2].real() + this.vector[2].imag() * complex3Vector.vector[2].imag(), this.vector[0].imag() * complex3Vector.vector[0].real() - this.vector[0].real() * complex3Vector.vector[0].imag() + this.vector[1].imag() * complex3Vector.vector[1].real() - this.vector[1].real() * complex3Vector.vector[1].imag() + this.vector[2].imag() * complex3Vector.vector[2].real() - this.vector[2].real() * complex3Vector.vector[2].imag());
    }

    public Complex3Vector multiply(Complex3Vector complex3Vector) {
        return new Complex3Vector(this.vector[1].multiply(complex3Vector.vector[2]).subtract(complex3Vector.vector[1].multiply(this.vector[2])), this.vector[2].multiply(complex3Vector.vector[0]).subtract(complex3Vector.vector[2].multiply(this.vector[0])), this.vector[0].multiply(complex3Vector.vector[1]).subtract(complex3Vector.vector[0].multiply(this.vector[1])));
    }

    public ComplexVector mapComponents(Mapping mapping) {
        return new Complex3Vector(mapping.map(this.vector[0]), mapping.map(this.vector[1]), mapping.map(this.vector[2]));
    }
}

