/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AlgebraMember;
import JSci.maths.Complex;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;
import JSci.maths.RingMember;
import JSci.maths.groups.AbelianGroupMember;

public class ComplexMatrix
extends Matrix {
    protected static final int ARRAY_2D = 1;
    protected static final int storageFormat = 1;
    protected Complex[][] matrix;

    protected ComplexMatrix() {
    }

    public ComplexMatrix(int n, int n2) {
        this.matrix = new Complex[n][n2];
    }

    public ComplexMatrix(Complex[][] complexArray) {
        this.matrix = complexArray;
    }

    public ComplexMatrix(ComplexVector[] complexVectorArray) {
        this(complexVectorArray[0].dimension(), complexVectorArray.length);
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                this.matrix[n][n2] = complexVectorArray[n2].getComponent(n);
                ++n2;
            }
            ++n;
        }
    }

    protected void finalize() throws Throwable {
        this.matrix = null;
        super.finalize();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexMatrix && this.matrix.length == ((ComplexMatrix)object).rows() && this.matrix[0].length == ((ComplexMatrix)object).columns()) {
            ComplexMatrix complexMatrix = (ComplexMatrix)object;
            int n = 0;
            while (n < this.matrix.length) {
                int n2 = 0;
                while (n2 < this.matrix[0].length) {
                    if (!this.matrix[n][n2].equals(complexMatrix.getElement(n, n2))) {
                        return false;
                    }
                    ++n2;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.matrix.length * this.matrix[0].length);
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                stringBuffer.append(this.matrix[n][n2].toString());
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.infNorm());
    }

    public DoubleMatrix real() {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                dArray[n][n2] = this.matrix[n][n2].real();
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public DoubleMatrix imag() {
        double[][] dArray = new double[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                dArray[n][n2] = this.matrix[n][n2].imag();
                ++n2;
            }
            ++n;
        }
        return new DoubleMatrix(dArray);
    }

    public Complex getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix.length && n2 >= 0 && n2 < this.matrix[0].length) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, Complex complex) {
        if (n >= 0 && n < this.matrix.length && n2 >= 0 && n2 < this.matrix[0].length) {
            this.matrix[n][n2] = complex;
            return;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.matrix.length) {
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                d2 += this.matrix[n][n2].mod();
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.matrix.length) {
            int n2 = 0;
            while (n2 < this.matrix[0].length) {
                d += this.matrix[n][n2].mod() * this.matrix[n][n2].mod();
                ++n2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    public int rows() {
        return this.matrix.length;
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public AbelianGroupMember negate() {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = (Complex)this.matrix[n][0].negate();
            int n2 = 1;
            while (n2 < complexArray[0].length) {
                complexArray[n][n2] = (Complex)this.matrix[n][n2].negate();
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof ComplexMatrix) {
            return this.add((ComplexMatrix)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(complexMatrix);
            }
        }
        if (this.matrix.length == complexMatrix.rows() && this.matrix[0].length == complexMatrix.columns()) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].add(complexMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.matrix[n][n2].add(complexMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrix.length == complexMatrix.matrix.length && this.matrix[0].length == complexMatrix.matrix[0].length) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].add(complexMatrix.matrix[n][0]);
                int n2 = 1;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.matrix[n][n2].add(complexMatrix.matrix[n][n2]);
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof ComplexMatrix) {
            return this.subtract((ComplexMatrix)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(complexMatrix);
            }
        }
        if (this.matrix.length == complexMatrix.rows() && this.matrix[0].length == complexMatrix.columns()) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].subtract(complexMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.matrix[n][n2].subtract(complexMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrix.length == complexMatrix.matrix.length && this.matrix[0].length == complexMatrix.matrix[0].length) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].subtract(complexMatrix.matrix[n][0]);
                int n2 = 1;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.matrix[n][n2].subtract(complexMatrix.matrix[n][n2]);
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AlgebraMember scalarMultiply(RingMember ringMember) {
        if (ringMember instanceof Complex) {
            return this.scalarMultiply((Complex)ringMember);
        }
        if (ringMember instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)ringMember).value());
        }
        if (ringMember instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = complex.multiply(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < complexArray[0].length) {
                complexArray[n][n2] = complex.multiply(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public ComplexMatrix scalarMultiply(double d) {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = this.matrix[n][0].multiply(d);
            int n2 = 1;
            while (n2 < complexArray[0].length) {
                complexArray[n][n2] = this.matrix[n][n2].multiply(d);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.matrix[0].length == complexVector.dimension()) {
            Complex[] complexArray = new Complex[this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n] = this.matrix[n][0].multiply(complexVector.getComponent(0));
                int n2 = 1;
                while (n2 < this.matrix[0].length) {
                    complexArray[n] = complexArray[n].add(this.matrix[n][n2].multiply(complexVector.getComponent(n2)));
                    ++n2;
                }
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof ComplexMatrix) {
            return this.multiply((ComplexMatrix)ringMember);
        }
        throw new IllegalArgumentException("Matrix class not recognised by this method.");
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(complexMatrix);
            }
        }
        if (this.matrix[0].length == complexMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix.length][complexMatrix.columns()];
            int n = 0;
            while (n < complexArray.length) {
                int n2 = 0;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.matrix[n][0].multiply(complexMatrix.getElement(0, n2));
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        complexArray[n][n2] = complexArray[n][n2].add(this.matrix[n][n3].multiply(complexMatrix.getElement(n3, n2)));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (complexArray.length == complexArray[0].length) {
                return new ComplexSquareMatrix(complexArray);
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.matrix.length) {
            Complex[][] complexArray = new Complex[this.matrix.length][complexMatrix.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                int n2 = 0;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.matrix[n][0].multiply(complexMatrix.matrix[0][n2]);
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        complexArray[n][n2] = complexArray[n][n2].add(this.matrix[n][n3].multiply(complexMatrix.matrix[n3][n2]));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (complexArray.length == complexArray[0].length) {
                return new ComplexSquareMatrix(complexArray);
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexMatrix hermitianAdjoint() {
        Complex[][] complexArray = new Complex[this.matrix[0].length][this.matrix.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[0][n] = this.matrix[n][0].conjugate();
            int n2 = 1;
            while (n2 < complexArray[0].length) {
                complexArray[n2][n] = this.matrix[n][n2].conjugate();
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public ComplexMatrix conjugate() {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = this.matrix[n][0].conjugate();
            int n2 = 1;
            while (n2 < complexArray[0].length) {
                complexArray[n][n2] = this.matrix[n][n2].conjugate();
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public Matrix transpose() {
        Complex[][] complexArray = new Complex[this.matrix[0].length][this.matrix.length];
        int n = 0;
        while (n < complexArray[0].length) {
            complexArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < complexArray.length) {
                complexArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }

    public ComplexMatrix mapElements(Mapping mapping) {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix[0].length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = mapping.map(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < complexArray[0].length) {
                complexArray[n][n2] = mapping.map(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new ComplexMatrix(complexArray);
    }
}

