/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerVector;
import JSci.maths.Mapping;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.MathVector;
import JSci.maths.ModuleMember;
import JSci.maths.RingMember;
import JSci.maths.VectorDimensionException;
import JSci.maths.groups.AbelianGroupMember;

public class ComplexVector
extends MathVector {
    protected static final int ARRAY_1D = 1;
    protected static final int storageFormat = 1;
    protected Complex[] vector;

    public ComplexVector(int n) {
        this.vector = new Complex[n];
    }

    public ComplexVector(Complex[] complexArray) {
        this.vector = complexArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexVector && this.vector.length == ((ComplexVector)object).dimension()) {
            ComplexVector complexVector = (ComplexVector)object;
            int n = 0;
            while (n < this.vector.length) {
                if (!this.vector[n].equals(complexVector.getComponent(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.vector.length);
        int n = 0;
        while (n < this.vector.length - 1) {
            stringBuffer.append(this.vector[n].toString());
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(this.vector[n].toString());
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public DoubleVector real() {
        double[] dArray = new double[this.vector.length];
        int n = 0;
        while (n < this.vector.length) {
            dArray[n] = this.vector[n].real();
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public DoubleVector imag() {
        double[] dArray = new double[this.vector.length];
        int n = 0;
        while (n < this.vector.length) {
            dArray[n] = this.vector[n].imag();
            ++n;
        }
        return new DoubleVector(dArray);
    }

    public Complex getComponent(int n) {
        if (n >= 0 && n < this.vector.length) {
            return this.vector[n];
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, Complex complex) {
        if (n >= 0 && n < this.vector.length) {
            this.vector[n] = complex;
            return;
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public int dimension() {
        return this.vector.length;
    }

    public double norm() {
        double d = this.vector[0].real() * this.vector[0].real() + this.vector[0].imag() * this.vector[0].imag();
        int n = 1;
        while (n < this.vector.length) {
            d += this.vector[n].real() * this.vector[n].real() + this.vector[n].imag() * this.vector[n].imag();
            ++n;
        }
        return Math.sqrt(d);
    }

    public double infNorm() {
        double d = this.vector[0].mod();
        int n = 1;
        while (n < this.vector.length) {
            if (this.vector[n].mod() > d) {
                d = this.vector[n].mod();
            }
            ++n;
        }
        return d;
    }

    public AbelianGroupMember negate() {
        Complex[] complexArray = new Complex[this.vector.length];
        complexArray[0] = (Complex)this.vector[0].negate();
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = (Complex)this.vector[n].negate();
            ++n;
        }
        return new ComplexVector(complexArray);
    }

    public ComplexVector conjugate() {
        Complex[] complexArray = new Complex[this.vector.length];
        complexArray[0] = this.vector[0].conjugate();
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = this.vector[n].conjugate();
            ++n;
        }
        return new ComplexVector(complexArray);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof ComplexVector) {
            return this.add((ComplexVector)abelianGroupMember);
        }
        if (abelianGroupMember instanceof DoubleVector) {
            return this.add((DoubleVector)abelianGroupMember);
        }
        if (abelianGroupMember instanceof IntegerVector) {
            return this.add((IntegerVector)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexVector add(ComplexVector complexVector) {
        switch (1) {
            case 1: {
                return this.rawAdd(complexVector);
            }
        }
        if (this.vector.length == complexVector.dimension()) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].add(complexVector.getComponent(0));
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].add(complexVector.getComponent(n));
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawAdd(ComplexVector complexVector) {
        if (this.vector.length == complexVector.vector.length) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].add(complexVector.vector[0]);
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].add(complexVector.vector[n]);
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(DoubleVector doubleVector) {
        switch (1) {
            case 1: {
                return this.rawAdd(doubleVector);
            }
        }
        if (this.vector.length == doubleVector.dimension()) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].addReal(doubleVector.getComponent(0));
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].addReal(doubleVector.getComponent(n));
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawAdd(DoubleVector doubleVector) {
        if (this.vector.length == doubleVector.vector.length) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].addReal(doubleVector.vector[0]);
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].addReal(doubleVector.vector[n]);
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(IntegerVector integerVector) {
        switch (1) {
            case 1: {
                return this.rawAdd(integerVector);
            }
        }
        if (this.vector.length == integerVector.dimension()) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].addReal(integerVector.getComponent(0));
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].addReal(integerVector.getComponent(n));
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawAdd(IntegerVector integerVector) {
        if (this.vector.length == integerVector.vector.length) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].addReal(integerVector.vector[0]);
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].addReal(integerVector.vector[n]);
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof ComplexVector) {
            return this.subtract((ComplexVector)abelianGroupMember);
        }
        if (abelianGroupMember instanceof DoubleVector) {
            return this.subtract((DoubleVector)abelianGroupMember);
        }
        if (abelianGroupMember instanceof IntegerVector) {
            return this.subtract((IntegerVector)abelianGroupMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexVector subtract(ComplexVector complexVector) {
        switch (1) {
            case 1: {
                return this.rawSubtract(complexVector);
            }
        }
        if (this.vector.length == complexVector.dimension()) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].subtract(complexVector.getComponent(0));
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].subtract(complexVector.getComponent(n));
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawSubtract(ComplexVector complexVector) {
        if (this.vector.length == complexVector.vector.length) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].subtract(complexVector.vector[0]);
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].subtract(complexVector.vector[n]);
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(DoubleVector doubleVector) {
        switch (1) {
            case 1: {
                return this.rawSubtract(doubleVector);
            }
        }
        if (this.vector.length == doubleVector.dimension()) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].subtractReal(doubleVector.getComponent(0));
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].subtractReal(doubleVector.getComponent(n));
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawSubtract(DoubleVector doubleVector) {
        if (this.vector.length == doubleVector.vector.length) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].subtractReal(doubleVector.vector[0]);
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].subtractReal(doubleVector.vector[n]);
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(IntegerVector integerVector) {
        switch (1) {
            case 1: {
                return this.rawSubtract(integerVector);
            }
        }
        if (this.vector.length == integerVector.dimension()) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].subtractReal(integerVector.getComponent(0));
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].subtractReal(integerVector.getComponent(n));
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawSubtract(IntegerVector integerVector) {
        if (this.vector.length == integerVector.vector.length) {
            Complex[] complexArray = new Complex[this.vector.length];
            complexArray[0] = this.vector[0].subtractReal(integerVector.vector[0]);
            int n = 1;
            while (n < complexArray.length) {
                complexArray[n] = this.vector[n].subtractReal(integerVector.vector[n]);
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ModuleMember scalarMultiply(RingMember ringMember) {
        if (ringMember instanceof Complex) {
            return this.scalarMultiply((Complex)ringMember);
        }
        if (ringMember instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)ringMember).value());
        }
        if (ringMember instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)ringMember).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexVector scalarMultiply(Complex complex) {
        Complex[] complexArray = new Complex[this.vector.length];
        complexArray[0] = this.vector[0].multiply(complex);
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = this.vector[n].multiply(complex);
            ++n;
        }
        return new ComplexVector(complexArray);
    }

    public ComplexVector scalarMultiply(double d) {
        Complex[] complexArray = new Complex[this.vector.length];
        complexArray[0] = this.vector[0].multiply(d);
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = this.vector[n].multiply(d);
            ++n;
        }
        return new ComplexVector(complexArray);
    }

    public ComplexVector scalarDivide(Complex complex) {
        Complex[] complexArray = new Complex[this.vector.length];
        complexArray[0] = this.vector[0].divide(complex);
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = this.vector[n].divide(complex);
            ++n;
        }
        return new ComplexVector(complexArray);
    }

    public ComplexVector scalarDivide(double d) {
        Complex[] complexArray = new Complex[this.vector.length];
        complexArray[0] = this.vector[0].divide(d);
        int n = 1;
        while (n < complexArray.length) {
            complexArray[n] = this.vector[n].divide(d);
            ++n;
        }
        return new ComplexVector(complexArray);
    }

    public Complex scalarProduct(ComplexVector complexVector) {
        switch (1) {
            case 1: {
                return this.rawScalarProduct(complexVector);
            }
        }
        if (this.vector.length == complexVector.dimension()) {
            double d = complexVector.getComponent(0).real();
            double d2 = complexVector.getComponent(0).imag();
            double d3 = this.vector[0].real() * d + this.vector[0].imag() * d2;
            double d4 = this.vector[0].imag() * d - this.vector[0].real() * d2;
            int n = 1;
            while (n < this.vector.length) {
                d = complexVector.getComponent(n).real();
                d2 = complexVector.getComponent(n).imag();
                d3 += this.vector[n].real() * d + this.vector[n].imag() * d2;
                d4 += this.vector[n].imag() * d - this.vector[n].real() * d2;
                ++n;
            }
            return new Complex(d3, d4);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private Complex rawScalarProduct(ComplexVector complexVector) {
        if (this.vector.length == complexVector.vector.length) {
            double d = this.vector[0].real() * complexVector.vector[0].real() + this.vector[0].imag() * complexVector.vector[0].imag();
            double d2 = this.vector[0].imag() * complexVector.vector[0].real() - this.vector[0].real() * complexVector.vector[0].imag();
            int n = 1;
            while (n < this.vector.length) {
                d += this.vector[n].real() * complexVector.vector[n].real() + this.vector[n].imag() * complexVector.vector[n].imag();
                d2 += this.vector[n].imag() * complexVector.vector[n].real() - this.vector[n].real() * complexVector.vector[n].imag();
                ++n;
            }
            return new Complex(d, d2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector mapComponents(Mapping mapping) {
        Complex[] complexArray = new Complex[this.vector.length];
        complexArray[0] = mapping.map(this.vector[0]);
        int n = 1;
        while (n < this.vector.length) {
            complexArray[n] = mapping.map(this.vector[n]);
            ++n;
        }
        return new ComplexVector(complexArray);
    }
}

