/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleTridiagonalMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerDiagonalMatrix;
import JSci.maths.IntegerMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class DoubleDiagonalMatrix
extends DoubleTridiagonalMatrix {
    protected static final int DIAGONAL = 4;
    protected static final int storageFormat = 4;

    protected DoubleDiagonalMatrix() {
    }

    public DoubleDiagonalMatrix(int n) {
        this();
        this.matrix = new double[1][n];
    }

    public DoubleDiagonalMatrix(double[][] dArray) {
        this(dArray.length);
        if (dArray.length == dArray[0].length) {
            int n = 0;
            while (n < this.matrix[0].length) {
                this.matrix[0][n] = dArray[n][n];
                ++n;
            }
            return;
        }
        this.matrix = null;
        throw new MatrixDimensionException("Array must be square.");
    }

    public DoubleDiagonalMatrix(double[] dArray) {
        this();
        this.matrix = new double[1][];
        this.matrix[0] = dArray;
    }

    public static DoubleDiagonalMatrix identity(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 1.0;
            ++n2;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleDiagonalMatrix && this.matrix[0].length == ((DoubleDiagonalMatrix)object).rows()) {
            DoubleDiagonalMatrix doubleDiagonalMatrix = (DoubleDiagonalMatrix)object;
            int n = 0;
            while (n < this.matrix[0].length) {
                if (Math.abs(this.matrix[0][n] - doubleDiagonalMatrix.getElement(n, n)) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public IntegerMatrix toIntegerMatrix() {
        int[] nArray = new int[this.matrix[0].length];
        int n = 0;
        while (n < this.matrix[0].length) {
            nArray[n] = Math.round((float)this.matrix[0][n]);
            ++n;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public ComplexMatrix toComplexMatrix() {
        Complex[] complexArray = new Complex[this.matrix[0].length];
        int n = 0;
        while (n < this.matrix[0].length) {
            complexArray[n] = new Complex(this.matrix[0][n], 0.0);
            ++n;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length) {
            if (n == n2) {
                return this.matrix[0][n];
            }
            return 0.0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length && n == n2) {
            this.matrix[0][n] = d;
            return;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isUnitary() {
        return this.multiply(this).equals(DoubleDiagonalMatrix.identity(this.matrix[0].length));
    }

    public double det() {
        double d = this.matrix[0][0];
        int n = 1;
        while (n < this.matrix[0].length) {
            d *= this.matrix[0][n];
            ++n;
        }
        return d;
    }

    public double trace() {
        double d = this.matrix[0][0];
        int n = 1;
        while (n < this.matrix[0].length) {
            d += this.matrix[0][n];
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d = Math.abs(this.matrix[0][0]);
        int n = 1;
        while (n < this.matrix[0].length) {
            double d2 = Math.abs(this.matrix[0][n]);
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = this.matrix[0][0] * this.matrix[0][0];
        int n = 1;
        while (n < this.matrix[0].length) {
            d += this.matrix[0][n] * this.matrix[0][n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public int rows() {
        return this.matrix[0].length;
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
            case 3: {
                return this.rawAdd((DoubleTridiagonalMatrix)doubleMatrix);
            }
            case 4: {
                return this.rawAdd((DoubleDiagonalMatrix)doubleMatrix);
            }
        }
        if (this.matrix[0].length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix.length && this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                System.arraycopy(doubleMatrix.matrix[n], 0, dArray[n], 0, dArray.length);
                ++n;
            }
            int n2 = 0;
            while (n2 < dArray.length) {
                double[] dArray2 = dArray[n2];
                int n3 = n2;
                dArray2[n3] = dArray2[n3] + this.matrix[0][n2];
                ++n2;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(doubleSquareMatrix);
            }
            case 3: {
                return this.rawAdd((DoubleTridiagonalMatrix)doubleSquareMatrix);
            }
            case 4: {
                return this.rawAdd((DoubleDiagonalMatrix)doubleSquareMatrix);
            }
        }
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix add(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (3) {
            case 3: {
                return this.rawAdd(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawAdd((DoubleDiagonalMatrix)doubleTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] + doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] + doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.matrix[2][n2] = doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] + doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawAdd(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        if (this.matrix[0].length == doubleTridiagonalMatrix.matrix[1].length) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(this.matrix[0].length);
            System.arraycopy(doubleTridiagonalMatrix.matrix[0], 0, doubleTridiagonalMatrix2.matrix[0], 0, this.matrix[0].length);
            System.arraycopy(doubleTridiagonalMatrix.matrix[2], 0, doubleTridiagonalMatrix2.matrix[2], 0, this.matrix[2].length);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] + doubleTridiagonalMatrix.matrix[1][0];
            int n = 1;
            while (n < this.matrix[0].length) {
                doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] + doubleTridiagonalMatrix.matrix[1][n];
                ++n;
            }
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix add(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.matrix[0].length == doubleDiagonalMatrix.matrix[0].length) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] + doubleDiagonalMatrix.matrix[0][0];
            int n = 1;
            while (n < dArray.length) {
                dArray[n] = this.matrix[0][n] + doubleDiagonalMatrix.matrix[0][n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
            case 3: {
                return this.rawSubtract((DoubleTridiagonalMatrix)doubleMatrix);
            }
            case 4: {
                return this.rawSubtract((DoubleDiagonalMatrix)doubleMatrix);
            }
        }
        if (this.matrix[0].length == doubleMatrix.rows() && this.matrix[0].length == doubleMatrix.columns()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = -doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = -doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix.length && this.matrix[0].length == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = -doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = -doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(doubleSquareMatrix);
            }
            case 3: {
                return this.rawSubtract((DoubleTridiagonalMatrix)doubleSquareMatrix);
            }
            case 4: {
                return this.rawSubtract((DoubleDiagonalMatrix)doubleSquareMatrix);
            }
        }
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = -doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = -doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < dArray.length) {
                double[] dArray2 = dArray[n3];
                int n4 = n3;
                dArray2[n4] = dArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleTridiagonalMatrix subtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (3) {
            case 3: {
                return this.rawSubtract(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawSubtract((DoubleDiagonalMatrix)doubleTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] - doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = -doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = -doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] - doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.matrix[2][n2] = -doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = -doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] - doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleTridiagonalMatrix rawSubtract(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.matrix[0].length;
        if (n == doubleTridiagonalMatrix.matrix[1].length) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] - doubleTridiagonalMatrix.matrix[1][0];
            doubleTridiagonalMatrix2.matrix[2][0] = -doubleTridiagonalMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = -doubleTridiagonalMatrix.matrix[0][n2];
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] - doubleTridiagonalMatrix.matrix[1][n2];
                doubleTridiagonalMatrix2.matrix[2][n2] = -doubleTridiagonalMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = -doubleTridiagonalMatrix.matrix[0][n];
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] - doubleTridiagonalMatrix.matrix[1][n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix subtract(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.matrix[0].length == doubleDiagonalMatrix.matrix[0].length) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] - doubleDiagonalMatrix.matrix[0][0];
            int n = 1;
            while (n < dArray.length) {
                dArray[n] = this.matrix[0][n] - doubleDiagonalMatrix.matrix[0][n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = d * this.matrix[0][0];
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = d * this.matrix[0][n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.matrix[0].length == doubleVector.dimension()) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] * doubleVector.getComponent(0);
            int n = 1;
            while (n < dArray.length) {
                dArray[n] = this.matrix[0][n] * doubleVector.getComponent(n);
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
            case 3: {
                return this.rawMultiply((DoubleTridiagonalMatrix)doubleMatrix);
            }
            case 4: {
                return this.rawMultiply((DoubleDiagonalMatrix)doubleMatrix);
            }
        }
        if (this.matrix[0].length == doubleMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][doubleMatrix.columns()];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[0][n] * doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[0][n] * doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.matrix[0].length == doubleMatrix.matrix.length) {
            double[][] dArray = new double[this.matrix[0].length][doubleMatrix.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[0][n] * doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.matrix[0][n] * doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(doubleSquareMatrix);
            }
            case 3: {
                return this.rawMultiply((DoubleTridiagonalMatrix)doubleSquareMatrix);
            }
            case 4: {
                return this.rawMultiply((DoubleDiagonalMatrix)doubleSquareMatrix);
            }
        }
        if (this.matrix[0].length == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[0][n] * doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[0][n] * doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.matrix[0].length == doubleSquareMatrix.matrix.length) {
            double[][] dArray = new double[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.matrix[0][n] * doubleSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.matrix[0][n] * doubleSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix multiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        switch (3) {
            case 3: {
                return this.rawMultiply(doubleTridiagonalMatrix);
            }
            case 4: {
                return this.rawMultiply((DoubleDiagonalMatrix)doubleTridiagonalMatrix);
            }
        }
        int n = this.matrix[0].length;
        if (n == doubleTridiagonalMatrix.rows()) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] * doubleTridiagonalMatrix.getElement(0, 0);
            doubleTridiagonalMatrix2.matrix[2][0] = this.matrix[0][0] * doubleTridiagonalMatrix.getElement(0, 1);
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.getElement(n2, n2 - 1);
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.getElement(n2, n2);
                doubleTridiagonalMatrix2.matrix[2][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.getElement(n2, n2 + 1);
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n, n - 1);
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] * doubleTridiagonalMatrix.getElement(n, n);
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleTridiagonalMatrix doubleTridiagonalMatrix) {
        int n = this.matrix[0].length;
        if (n == doubleTridiagonalMatrix.matrix[1].length) {
            DoubleTridiagonalMatrix doubleTridiagonalMatrix2 = new DoubleTridiagonalMatrix(n);
            doubleTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] * doubleTridiagonalMatrix.matrix[1][0];
            doubleTridiagonalMatrix2.matrix[2][0] = this.matrix[0][0] * doubleTridiagonalMatrix.matrix[2][0];
            --n;
            int n2 = 1;
            while (n2 < n) {
                doubleTridiagonalMatrix2.matrix[0][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.matrix[0][n2];
                doubleTridiagonalMatrix2.matrix[1][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.matrix[1][n2];
                doubleTridiagonalMatrix2.matrix[2][n2] = this.matrix[0][n2] * doubleTridiagonalMatrix.matrix[2][n2];
                ++n2;
            }
            doubleTridiagonalMatrix2.matrix[0][n] = this.matrix[0][n] * doubleTridiagonalMatrix.matrix[0][n];
            doubleTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] * doubleTridiagonalMatrix.matrix[1][n];
            return doubleTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleDiagonalMatrix multiply(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        switch (4) {
            case 4: {
                return this.rawMultiply(doubleDiagonalMatrix);
            }
        }
        if (this.matrix[0].length == doubleDiagonalMatrix.rows()) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] * doubleDiagonalMatrix.getElement(0, 0);
            int n = 1;
            while (n < dArray.length) {
                dArray[n] = this.matrix[0][n] * doubleDiagonalMatrix.getElement(n, n);
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleDiagonalMatrix rawMultiply(DoubleDiagonalMatrix doubleDiagonalMatrix) {
        if (this.matrix[0].length == doubleDiagonalMatrix.matrix[0].length) {
            double[] dArray = new double[this.matrix[0].length];
            dArray[0] = this.matrix[0][0] * doubleDiagonalMatrix.matrix[0][0];
            int n = 1;
            while (n < dArray.length) {
                dArray[n] = this.matrix[0][n] * doubleDiagonalMatrix.matrix[0][n];
                ++n;
            }
            return new DoubleDiagonalMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix inverse() {
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = 1.0 / this.matrix[0][0];
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = 1.0 / this.matrix[0][n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public Matrix transpose() {
        return this;
    }

    public DoubleSquareMatrix[] luDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[]{DoubleDiagonalMatrix.identity(this.matrix[0].length), this};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[2];
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = Math.sqrt(this.matrix[0][0]);
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = Math.sqrt(this.matrix[0][n]);
            ++n;
        }
        doubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        doubleSquareMatrixArray[1] = doubleSquareMatrixArray[0];
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = mapping.map(this.matrix[0][0]);
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = mapping.map(this.matrix[0][n]);
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }
}

