/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.Complex;
import JSci.maths.NumericalConstants;

public final class FourierMath
extends AbstractMath
implements NumericalConstants {
    private FourierMath() {
    }

    public static Complex[] transform(Complex[] complexArray) {
        int n;
        double[][] dArray = new double[2][complexArray.length];
        if (!FourierMath.isPowerOf2(complexArray.length)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        int n2 = FourierMath.numberOfBitsNeeded(complexArray.length);
        int n3 = 0;
        while (n3 < complexArray.length) {
            n = FourierMath.reverseBits(n3, n2);
            dArray[0][n] = complexArray[n3].real();
            dArray[1][n] = complexArray[n3].imag();
            ++n3;
        }
        int n4 = 1;
        int n5 = 2;
        while (n5 <= complexArray.length) {
            double d = Math.PI * 2 / (double)n5;
            double d2 = Math.sin(0.5 * d);
            d2 = 2.0 * d2 * d2;
            double d3 = Math.sin(d);
            n3 = 0;
            while (n3 < complexArray.length) {
                double d4 = 1.0;
                double d5 = 0.0;
                n = n3;
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = n + n4;
                    double d6 = d4 * dArray[0][n7] - d5 * dArray[1][n7];
                    double d7 = d4 * dArray[1][n7] + d5 * dArray[0][n7];
                    dArray[0][n7] = dArray[0][n] - d6;
                    dArray[1][n7] = dArray[1][n] - d7;
                    double[] dArray2 = dArray[0];
                    int n8 = n;
                    dArray2[n8] = dArray2[n8] + d6;
                    double[] dArray3 = dArray[1];
                    int n9 = n++;
                    dArray3[n9] = dArray3[n9] + d7;
                    d6 = d2 * d4 + d3 * d5;
                    d7 = d2 * d5 - d3 * d4;
                    d4 -= d6;
                    d5 -= d7;
                    ++n6;
                }
                n3 += n5;
            }
            n4 = n5;
            n5 <<= 1;
        }
        Complex[] complexArray2 = new Complex[complexArray.length];
        n3 = 0;
        while (n3 < complexArray.length) {
            complexArray2[n3] = new Complex(dArray[0][n3], dArray[1][n3]);
            ++n3;
        }
        return complexArray2;
    }

    public static Complex[] transform(double[] dArray) {
        int n;
        double[][] dArray2 = new double[2][dArray.length];
        if (!FourierMath.isPowerOf2(dArray.length)) {
            throw new IllegalArgumentException("The number of samples must be a power of 2.");
        }
        int n2 = FourierMath.numberOfBitsNeeded(dArray.length);
        int n3 = 0;
        while (n3 < dArray.length) {
            n = FourierMath.reverseBits(n3, n2);
            dArray2[0][n] = dArray[n3];
            dArray2[1][n] = 0.0;
            ++n3;
        }
        int n4 = 1;
        int n5 = 2;
        while (n5 <= dArray.length) {
            double d = Math.PI * 2 / (double)n5;
            double d2 = Math.sin(0.5 * d);
            d2 = 2.0 * d2 * d2;
            double d3 = Math.sin(d);
            n3 = 0;
            while (n3 < dArray.length) {
                double d4 = 1.0;
                double d5 = 0.0;
                n = n3;
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = n + n4;
                    double d6 = d4 * dArray2[0][n7] - d5 * dArray2[1][n7];
                    double d7 = d4 * dArray2[1][n7] + d5 * dArray2[0][n7];
                    dArray2[0][n7] = dArray2[0][n] - d6;
                    dArray2[1][n7] = dArray2[1][n] - d7;
                    double[] dArray3 = dArray2[0];
                    int n8 = n;
                    dArray3[n8] = dArray3[n8] + d6;
                    double[] dArray4 = dArray2[1];
                    int n9 = n++;
                    dArray4[n9] = dArray4[n9] + d7;
                    d6 = d2 * d4 + d3 * d5;
                    d7 = d2 * d5 - d3 * d4;
                    d4 -= d6;
                    d5 -= d7;
                    ++n6;
                }
                n3 += n5;
            }
            n4 = n5;
            n5 <<= 1;
        }
        Complex[] complexArray = new Complex[dArray.length];
        n3 = 0;
        while (n3 < dArray.length) {
            complexArray[n3] = new Complex(dArray2[0][n3], dArray2[1][n3]);
            ++n3;
        }
        return complexArray;
    }

    public static Complex[] inverseTransform(Complex[] complexArray) {
        int n;
        double[][] dArray = new double[2][complexArray.length];
        if (!FourierMath.isPowerOf2(complexArray.length)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        int n2 = FourierMath.numberOfBitsNeeded(complexArray.length);
        int n3 = 0;
        while (n3 < complexArray.length) {
            n = FourierMath.reverseBits(n3, n2);
            dArray[0][n] = complexArray[n3].real();
            dArray[1][n] = complexArray[n3].imag();
            ++n3;
        }
        int n4 = 1;
        int n5 = 2;
        while (n5 <= complexArray.length) {
            double d = Math.PI * -2 / (double)n5;
            double d2 = Math.sin(0.5 * d);
            d2 = 2.0 * d2 * d2;
            double d3 = Math.sin(d);
            n3 = 0;
            while (n3 < complexArray.length) {
                double d4 = 1.0;
                double d5 = 0.0;
                n = n3;
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = n + n4;
                    double d6 = d4 * dArray[0][n7] - d5 * dArray[1][n7];
                    double d7 = d4 * dArray[1][n7] + d5 * dArray[0][n7];
                    dArray[0][n7] = dArray[0][n] - d6;
                    dArray[1][n7] = dArray[1][n] - d7;
                    double[] dArray2 = dArray[0];
                    int n8 = n;
                    dArray2[n8] = dArray2[n8] + d6;
                    double[] dArray3 = dArray[1];
                    int n9 = n++;
                    dArray3[n9] = dArray3[n9] + d7;
                    d6 = d2 * d4 + d3 * d5;
                    d7 = d2 * d5 - d3 * d4;
                    d4 -= d6;
                    d5 -= d7;
                    ++n6;
                }
                n3 += n5;
            }
            n4 = n5;
            n5 <<= 1;
        }
        Complex[] complexArray2 = new Complex[complexArray.length];
        double d = complexArray.length;
        n3 = 0;
        while (n3 < complexArray.length) {
            complexArray2[n3] = new Complex(dArray[0][n3] / d, dArray[1][n3] / d);
            ++n3;
        }
        return complexArray2;
    }

    public static Complex[] inverseTransform(double[] dArray) {
        int n;
        double[][] dArray2 = new double[2][dArray.length];
        if (!FourierMath.isPowerOf2(dArray.length)) {
            throw new IllegalArgumentException("Data length must be a power of 2.");
        }
        int n2 = FourierMath.numberOfBitsNeeded(dArray.length);
        int n3 = 0;
        while (n3 < dArray.length) {
            n = FourierMath.reverseBits(n3, n2);
            dArray2[0][n] = dArray[n3];
            dArray2[1][n] = 0.0;
            ++n3;
        }
        int n4 = 1;
        int n5 = 2;
        while (n5 <= dArray.length) {
            double d = Math.PI * -2 / (double)n5;
            double d2 = Math.sin(0.5 * d);
            d2 = 2.0 * d2 * d2;
            double d3 = Math.sin(d);
            n3 = 0;
            while (n3 < dArray.length) {
                double d4 = 1.0;
                double d5 = 0.0;
                n = n3;
                int n6 = 0;
                while (n6 < n4) {
                    int n7 = n + n4;
                    double d6 = d4 * dArray2[0][n7] - d5 * dArray2[1][n7];
                    double d7 = d4 * dArray2[1][n7] + d5 * dArray2[0][n7];
                    dArray2[0][n7] = dArray2[0][n] - d6;
                    dArray2[1][n7] = dArray2[1][n] - d7;
                    double[] dArray3 = dArray2[0];
                    int n8 = n;
                    dArray3[n8] = dArray3[n8] + d6;
                    double[] dArray4 = dArray2[1];
                    int n9 = n++;
                    dArray4[n9] = dArray4[n9] + d7;
                    d6 = d2 * d4 + d3 * d5;
                    d7 = d2 * d5 - d3 * d4;
                    d4 -= d6;
                    d5 -= d7;
                    ++n6;
                }
                n3 += n5;
            }
            n4 = n5;
            n5 <<= 1;
        }
        Complex[] complexArray = new Complex[dArray.length];
        double d = dArray.length;
        n3 = 0;
        while (n3 < dArray.length) {
            complexArray[n3] = new Complex(dArray2[0][n3] / d, dArray2[1][n3] / d);
            ++n3;
        }
        return complexArray;
    }

    private static boolean isPowerOf2(int n) {
        int n2 = 32;
        int n3 = 1;
        int n4 = 2;
        while (n3 < n2) {
            if (n == n4) {
                return true;
            }
            ++n3;
            n4 <<= 1;
        }
        return false;
    }

    private static int numberOfBitsNeeded(int n) {
        if (n < 2) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        while ((n & 1 << n2) <= 0) {
            ++n2;
        }
        return n2;
    }

    private static int reverseBits(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 << 1 | n & 1;
            n >>= 1;
            ++n4;
        }
        return n3;
    }

    public static Complex[] sort(Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[complexArray.length];
        int n = complexArray.length / 2;
        int n2 = 0;
        while (n2 < n) {
            complexArray2[n + n2] = complexArray[n2];
            complexArray2[n2] = complexArray[n + n2];
            ++n2;
        }
        return complexArray2;
    }
}

