/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleDiagonalMatrix;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.IntegerTridiagonalMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class IntegerDiagonalMatrix
extends IntegerTridiagonalMatrix {
    protected static final int DIAGONAL = 4;
    protected static final int storageFormat = 4;

    protected IntegerDiagonalMatrix() {
    }

    public IntegerDiagonalMatrix(int n) {
        this();
        this.matrix = new int[1][n];
    }

    public IntegerDiagonalMatrix(int[][] nArray) {
        this(nArray.length);
        if (nArray.length == nArray[0].length) {
            int n = 0;
            while (n < this.matrix[0].length) {
                this.matrix[0][n] = nArray[n][n];
                ++n;
            }
            return;
        }
        this.matrix = null;
        throw new MatrixDimensionException("Array must be square.");
    }

    public IntegerDiagonalMatrix(int[] nArray) {
        this();
        this.matrix = new int[1][];
        this.matrix[0] = nArray;
    }

    public static IntegerDiagonalMatrix identity(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 1;
            ++n2;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntegerDiagonalMatrix && this.matrix[0].length == ((IntegerDiagonalMatrix)object).rows()) {
            IntegerDiagonalMatrix integerDiagonalMatrix = (IntegerDiagonalMatrix)object;
            int n = 0;
            while (n < this.matrix[0].length) {
                if (this.matrix[0][n] != integerDiagonalMatrix.getElement(n, n)) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public DoubleMatrix toDoubleMatrix() {
        double[] dArray = new double[this.matrix[0].length];
        int n = 0;
        while (n < this.matrix[0].length) {
            dArray[n] = this.matrix[0][n];
            ++n;
        }
        return new DoubleDiagonalMatrix(dArray);
    }

    public ComplexMatrix toComplexMatrix() {
        Complex[] complexArray = new Complex[this.matrix[0].length];
        int n = 0;
        while (n < this.matrix[0].length) {
            complexArray[n] = new Complex(this.matrix[0][n], 0.0);
            ++n;
        }
        return new ComplexDiagonalMatrix(complexArray);
    }

    public int getElement(int n, int n2) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length) {
            if (n == n2) {
                return this.matrix[0][n];
            }
            return 0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, int n3) {
        if (n >= 0 && n < this.matrix[0].length && n2 >= 0 && n2 < this.matrix[0].length && n == n2) {
            this.matrix[0][n] = n3;
            return;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public boolean isSymmetric() {
        return true;
    }

    public boolean isUnitary() {
        return this.multiply(this).equals(IntegerDiagonalMatrix.identity(this.matrix[0].length));
    }

    public int det() {
        int n = this.matrix[0][0];
        int n2 = 1;
        while (n2 < this.matrix[0].length) {
            n *= this.matrix[0][n2];
            ++n2;
        }
        return n;
    }

    public int trace() {
        int n = this.matrix[0][0];
        int n2 = 1;
        while (n2 < this.matrix[0].length) {
            n += this.matrix[0][n2];
            ++n2;
        }
        return n;
    }

    public int infNorm() {
        int n = Math.abs(this.matrix[0][0]);
        int n2 = 1;
        while (n2 < this.matrix[0].length) {
            int n3 = Math.abs(this.matrix[0][n2]);
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    public double frobeniusNorm() {
        int n = this.matrix[0][0] * this.matrix[0][0];
        int n2 = 1;
        while (n2 < this.matrix[0].length) {
            n += this.matrix[0][n2] * this.matrix[0][n2];
            ++n2;
        }
        return Math.sqrt(n);
    }

    public int rows() {
        return this.matrix[0].length;
    }

    public int columns() {
        return this.matrix[0].length;
    }

    public IntegerMatrix add(IntegerMatrix integerMatrix) {
        if (integerMatrix instanceof IntegerDiagonalMatrix) {
            return this.add((IntegerDiagonalMatrix)integerMatrix);
        }
        if (integerMatrix instanceof IntegerTridiagonalMatrix) {
            return this.rawAdd((IntegerTridiagonalMatrix)integerMatrix);
        }
        if (integerMatrix instanceof IntegerSquareMatrix) {
            return this.rawAdd((IntegerSquareMatrix)integerMatrix);
        }
        return this.rawAdd(integerMatrix);
    }

    private IntegerMatrix rawAdd(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.rows() && this.matrix[0].length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                System.arraycopy(integerMatrix.matrix[n], 0, nArray[n], 0, nArray.length);
                ++n;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                int[] nArray2 = nArray[n2];
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + this.matrix[0][n2];
                ++n2;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        if (integerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.add((IntegerDiagonalMatrix)integerSquareMatrix);
        }
        if (integerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.rawAdd((IntegerTridiagonalMatrix)integerSquareMatrix);
        }
        return this.rawAdd(integerSquareMatrix);
    }

    private IntegerSquareMatrix rawAdd(IntegerSquareMatrix integerSquareMatrix) {
        if (this.matrix[0].length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                System.arraycopy(integerSquareMatrix.matrix[n], 0, nArray[n], 0, nArray.length);
                ++n;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                int[] nArray2 = nArray[n2];
                int n3 = n2;
                nArray2[n3] = nArray2[n3] + this.matrix[0][n2];
                ++n2;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix add(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (integerTridiagonalMatrix instanceof IntegerDiagonalMatrix) {
            return this.add((IntegerDiagonalMatrix)integerTridiagonalMatrix);
        }
        return this.rawAdd(integerTridiagonalMatrix);
    }

    private IntegerTridiagonalMatrix rawAdd(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (this.matrix[0].length == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(this.matrix[0].length);
            System.arraycopy(integerTridiagonalMatrix.matrix[0], 0, integerTridiagonalMatrix2.matrix[0], 0, this.matrix[0].length);
            System.arraycopy(integerTridiagonalMatrix.matrix[2], 0, integerTridiagonalMatrix2.matrix[2], 0, this.matrix[2].length);
            integerTridiagonalMatrix2.matrix[1][0] = this.matrix[0][0] + integerTridiagonalMatrix.matrix[1][0];
            int n = 1;
            while (n < this.matrix[0].length) {
                integerTridiagonalMatrix2.matrix[1][n] = this.matrix[0][n] + integerTridiagonalMatrix.matrix[1][n];
                ++n;
            }
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix add(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.matrix[0].length == integerDiagonalMatrix.rows()) {
            int[] nArray = new int[this.matrix[0].length];
            nArray[0] = this.matrix[0][0] + integerDiagonalMatrix.getElement(0, 0);
            int n = 1;
            while (n < nArray.length) {
                nArray[n] = this.matrix[0][n] + integerDiagonalMatrix.getElement(n, n);
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix subtract(IntegerMatrix integerMatrix) {
        if (integerMatrix instanceof IntegerDiagonalMatrix) {
            return this.subtract((IntegerDiagonalMatrix)integerMatrix);
        }
        if (integerMatrix instanceof IntegerTridiagonalMatrix) {
            return this.rawSubtract((IntegerTridiagonalMatrix)integerMatrix);
        }
        if (integerMatrix instanceof IntegerSquareMatrix) {
            return this.rawSubtract((IntegerSquareMatrix)integerMatrix);
        }
        return this.rawSubtract(integerMatrix);
    }

    private IntegerMatrix rawSubtract(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.rows() && this.matrix[0].length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = -integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = -integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        if (integerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.subtract((IntegerDiagonalMatrix)integerSquareMatrix);
        }
        if (integerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.rawSubtract((IntegerTridiagonalMatrix)integerSquareMatrix);
        }
        return this.rawSubtract(integerSquareMatrix);
    }

    private IntegerSquareMatrix rawSubtract(IntegerSquareMatrix integerSquareMatrix) {
        if (this.matrix[0].length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = -integerSquareMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = -integerSquareMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            int n3 = 0;
            while (n3 < nArray.length) {
                int[] nArray2 = nArray[n3];
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + this.matrix[0][n3];
                ++n3;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerTridiagonalMatrix subtract(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (integerTridiagonalMatrix instanceof IntegerDiagonalMatrix) {
            return this.subtract((IntegerDiagonalMatrix)integerTridiagonalMatrix);
        }
        return this.rawSubtract(integerTridiagonalMatrix);
    }

    private IntegerTridiagonalMatrix rawSubtract(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (this.matrix[0].length == integerTridiagonalMatrix.rows()) {
            int n = this.matrix[0].length;
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0] - integerTridiagonalMatrix.getElement(0, 0));
            integerTridiagonalMatrix2.setElement(1, 0, -integerTridiagonalMatrix.getElement(1, 0));
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.setElement(n2 - 1, n2, -integerTridiagonalMatrix.getElement(n2 - 1, n2));
                integerTridiagonalMatrix2.setElement(n2, n2, this.matrix[0][n2] - integerTridiagonalMatrix.getElement(n2, n2));
                integerTridiagonalMatrix2.setElement(n2 + 1, n2, -integerTridiagonalMatrix.getElement(n2 + 1, n2));
                ++n2;
            }
            integerTridiagonalMatrix2.setElement(n - 1, n, -integerTridiagonalMatrix.getElement(n - 1, n));
            integerTridiagonalMatrix2.setElement(n, n, this.matrix[0][n] - integerTridiagonalMatrix.getElement(n, n));
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix subtract(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.matrix[0].length == integerDiagonalMatrix.rows()) {
            int[] nArray = new int[this.matrix[0].length];
            nArray[0] = this.matrix[0][0] - integerDiagonalMatrix.matrix[0][0];
            int n = 1;
            while (n < nArray.length) {
                nArray[n] = this.matrix[0][n] - integerDiagonalMatrix.matrix[0][n];
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix scalarMultiply(int n) {
        int[] nArray = new int[this.matrix[0].length];
        nArray[0] = n * this.matrix[0][0];
        int n2 = 1;
        while (n2 < nArray.length) {
            nArray[n2] = n * this.matrix[0][n2];
            ++n2;
        }
        return new IntegerDiagonalMatrix(nArray);
    }

    public IntegerVector multiply(IntegerVector integerVector) {
        if (this.matrix[0].length == integerVector.dimension()) {
            int[] nArray = new int[this.matrix[0].length];
            nArray[0] = this.matrix[0][0] * integerVector.getComponent(0);
            int n = 1;
            while (n < nArray.length) {
                nArray[n] = this.matrix[0][n] * integerVector.getComponent(n);
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public IntegerMatrix multiply(IntegerMatrix integerMatrix) {
        if (integerMatrix instanceof IntegerDiagonalMatrix) {
            return this.multiply((IntegerDiagonalMatrix)integerMatrix);
        }
        if (integerMatrix instanceof IntegerTridiagonalMatrix) {
            return this.rawMultiply((IntegerTridiagonalMatrix)integerMatrix);
        }
        if (integerMatrix instanceof IntegerSquareMatrix) {
            return this.rawMultiply((IntegerSquareMatrix)integerMatrix);
        }
        return this.rawMultiply(integerMatrix);
    }

    private IntegerMatrix rawMultiply(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.rows()) {
            int[][] nArray = new int[this.matrix[0].length][integerMatrix.columns()];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[0][n] * integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[0][n] * integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        if (integerSquareMatrix instanceof IntegerDiagonalMatrix) {
            return this.multiply((IntegerDiagonalMatrix)integerSquareMatrix);
        }
        if (integerSquareMatrix instanceof IntegerTridiagonalMatrix) {
            return this.rawMultiply((IntegerTridiagonalMatrix)integerSquareMatrix);
        }
        return this.rawMultiply(integerSquareMatrix);
    }

    private IntegerSquareMatrix rawMultiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.matrix[0].length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix[0].length][this.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[0][n] * integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[0][n] * integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix multiply(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        if (integerTridiagonalMatrix instanceof IntegerDiagonalMatrix) {
            return this.multiply((IntegerDiagonalMatrix)integerTridiagonalMatrix);
        }
        return this.rawMultiply(integerTridiagonalMatrix);
    }

    private IntegerSquareMatrix rawMultiply(IntegerTridiagonalMatrix integerTridiagonalMatrix) {
        int n = this.matrix[0].length;
        if (n == integerTridiagonalMatrix.rows()) {
            IntegerTridiagonalMatrix integerTridiagonalMatrix2 = new IntegerTridiagonalMatrix(n);
            integerTridiagonalMatrix2.setElement(0, 0, this.matrix[0][0] * integerTridiagonalMatrix.getElement(0, 0));
            integerTridiagonalMatrix2.setElement(0, 1, this.matrix[0][0] * integerTridiagonalMatrix.getElement(0, 1));
            --n;
            int n2 = 1;
            while (n2 < n) {
                integerTridiagonalMatrix2.setElement(n2, n2 - 1, this.matrix[0][n2] * integerTridiagonalMatrix.getElement(n2, n2 - 1));
                integerTridiagonalMatrix2.setElement(n2, n2, this.matrix[0][n2] * integerTridiagonalMatrix.getElement(n2, n2));
                integerTridiagonalMatrix2.setElement(n2, n2 + 1, this.matrix[0][n2] * integerTridiagonalMatrix.getElement(n2, n2 + 1));
                ++n2;
            }
            integerTridiagonalMatrix2.setElement(n, n - 1, this.matrix[0][n] * integerTridiagonalMatrix.getElement(n, n - 1));
            integerTridiagonalMatrix2.setElement(n, n, this.matrix[0][n] * integerTridiagonalMatrix.getElement(n, n));
            return integerTridiagonalMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerDiagonalMatrix multiply(IntegerDiagonalMatrix integerDiagonalMatrix) {
        if (this.matrix[0].length == integerDiagonalMatrix.rows()) {
            int[] nArray = new int[this.matrix[0].length];
            nArray[0] = this.matrix[0][0] * integerDiagonalMatrix.getElement(0, 0);
            int n = 1;
            while (n < nArray.length) {
                nArray[n] = this.matrix[0][n] * integerDiagonalMatrix.getElement(n, n);
                ++n;
            }
            return new IntegerDiagonalMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public Matrix transpose() {
        return this;
    }

    public DoubleSquareMatrix[] luDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[]{DoubleDiagonalMatrix.identity(this.matrix[0].length), (DoubleDiagonalMatrix)this.toDoubleMatrix()};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleDiagonalMatrix[2];
        double[] dArray = new double[this.matrix[0].length];
        dArray[0] = Math.sqrt(this.matrix[0][0]);
        int n = 1;
        while (n < dArray.length) {
            dArray[n] = Math.sqrt(this.matrix[0][n]);
            ++n;
        }
        doubleSquareMatrixArray[0] = new DoubleDiagonalMatrix(dArray);
        doubleSquareMatrixArray[1] = doubleSquareMatrixArray[0];
        return doubleSquareMatrixArray;
    }
}

