/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.DimensionException;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.IntegerDiagonalMatrix;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public class IntegerSquareMatrix
extends IntegerMatrix {
    protected IntegerSquareMatrix() {
    }

    public IntegerSquareMatrix(int n) {
        super(n, n);
    }

    public IntegerSquareMatrix(int[][] nArray) {
        super(nArray);
        if (nArray.length != nArray[0].length) {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
    }

    public IntegerSquareMatrix(IntegerVector[] integerVectorArray) {
        super(integerVectorArray);
        if (integerVectorArray.length != integerVectorArray[0].dimension()) {
            this.matrix = null;
            throw new MatrixDimensionException("The array does not form a square matrix.");
        }
    }

    public boolean isSymmetric() {
        return this.equals(this.transpose());
    }

    public boolean isUnitary() {
        return this.multiply(this.transpose()).equals(IntegerDiagonalMatrix.identity(this.matrix[0].length));
    }

    public int det() {
        if (this.matrix.length == 2) {
            return this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose();
        double d = doubleSquareMatrixArray[1].matrix[0][0];
        int n = 1;
        while (n < this.matrix.length) {
            d *= doubleSquareMatrixArray[1].matrix[n][n];
            ++n;
        }
        return (int)d;
    }

    public int trace() {
        int n = this.matrix[0][0];
        int n2 = 1;
        while (n2 < this.matrix.length) {
            n += this.matrix[n2][n2];
            ++n2;
        }
        return n;
    }

    public IntegerMatrix add(IntegerMatrix integerMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(integerMatrix);
            }
        }
        if (this.matrix.length == integerMatrix.rows() && this.matrix.length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] + integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[n][n2] + integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawAdd(IntegerMatrix integerMatrix) {
        if (this.matrix.length == integerMatrix.matrix.length && this.matrix.length == integerMatrix.matrix[0].length) {
            int[][] nArray = new int[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] + integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[n][n2] + integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(integerSquareMatrix);
            }
        }
        if (this.matrix.length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] + integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[n][n2] + integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix subtract(IntegerMatrix integerMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(integerMatrix);
            }
        }
        if (this.matrix.length == integerMatrix.rows() && this.matrix.length == integerMatrix.columns()) {
            int[][] nArray = new int[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] - integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[n][n2] - integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawSubtract(IntegerMatrix integerMatrix) {
        if (this.matrix.length == integerMatrix.matrix.length && this.matrix.length == integerMatrix.matrix[0].length) {
            int[][] nArray = new int[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] - integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[n][n2] - integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(integerSquareMatrix);
            }
        }
        if (this.matrix.length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n][0] = this.matrix[n][0] - integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[n][n2] - integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix scalarMultiply(int n) {
        int[][] nArray = new int[this.matrix.length][this.matrix.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2][0] = n * this.matrix[n2][0];
            int n3 = 1;
            while (n3 < nArray.length) {
                nArray[n2][n3] = n * this.matrix[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return new IntegerSquareMatrix(nArray);
    }

    public IntegerVector multiply(IntegerVector integerVector) {
        if (this.matrix.length == integerVector.dimension()) {
            int[] nArray = new int[this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.matrix[n][0] * integerVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.matrix.length) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] + this.matrix[n][n2] * integerVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public IntegerMatrix multiply(IntegerMatrix integerMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(integerMatrix);
            }
        }
        if (this.matrix[0].length == integerMatrix.rows()) {
            int[][] nArray = new int[this.matrix.length][integerMatrix.columns()];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[n][0] * integerMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerMatrix rawMultiply(IntegerMatrix integerMatrix) {
        if (this.matrix[0].length == integerMatrix.matrix.length) {
            int[][] nArray = new int[this.matrix.length][integerMatrix.matrix[0].length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray[0].length) {
                    nArray[n][n2] = this.matrix[n][0] * integerMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(integerSquareMatrix);
            }
        }
        if (this.matrix.length == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[n][0] * integerSquareMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < nArray.length) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerSquareMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerSquareMatrix rawMultiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.matrix.length == integerSquareMatrix.matrix.length) {
            int[][] nArray = new int[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < nArray.length) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n][n2] = this.matrix[n][0] * integerSquareMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < nArray.length) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerSquareMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        int[][] nArray = new int[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < nArray.length) {
                nArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new IntegerSquareMatrix(nArray);
    }

    public DoubleSquareMatrix[] luDecompose() {
        double[][][] dArray = new double[2][this.matrix.length][this.matrix.length];
        dArray[0][0][0] = 1.0;
        int n = 1;
        while (n < this.matrix.length) {
            dArray[0][n][n] = 1.0;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.matrix.length) {
            int n3;
            double d;
            n = 0;
            while (n <= n2) {
                d = this.matrix[n][n2];
                n3 = 0;
                while (n3 < n) {
                    d -= dArray[0][n][n3] * dArray[1][n3][n2];
                    ++n3;
                }
                dArray[1][n][n2] = d;
                ++n;
            }
            n = n2 + 1;
            while (n < this.matrix.length) {
                d = this.matrix[n][n2];
                n3 = 0;
                while (n3 < n2) {
                    d -= dArray[0][n][n3] * dArray[1][n3][n2];
                    ++n3;
                }
                dArray[0][n][n2] = d / dArray[1][n2][n2];
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] choleskyDecomposition() {
        double[][][] dArray = new double[2][this.matrix.length][this.matrix.length];
        double d = Math.sqrt(this.matrix[0][0]);
        dArray[1][0][0] = d;
        dArray[0][0][0] = d;
        int n = 1;
        while (n < this.matrix.length) {
            double d2 = (double)this.matrix[n][0] / dArray[0][0][0];
            dArray[1][0][n] = d2;
            dArray[0][n][0] = d2;
            ++n;
        }
        int n2 = 1;
        while (n2 < this.matrix.length) {
            double d3 = this.matrix[n2][n2];
            n = 0;
            while (n < n2) {
                d3 -= dArray[0][n2][n] * dArray[0][n2][n];
                ++n;
            }
            double d4 = Math.sqrt(d3);
            dArray[1][n2][n2] = d4;
            dArray[0][n2][n2] = d4;
            n = n2 + 1;
            while (n < this.matrix.length) {
                d3 = this.matrix[n][n2];
                int n3 = 0;
                while (n3 < n) {
                    d3 -= dArray[0][n2][n3] * dArray[1][n3][n];
                    ++n3;
                }
                double d5 = d3 / dArray[1][n2][n2];
                dArray[1][n2][n] = d5;
                dArray[0][n][n2] = d5;
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }
}

