/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.MathInteger;
import JSci.maths.RingMember;
import JSci.maths.fields.FieldMember;
import JSci.maths.groups.AbelianGroupMember;
import java.io.Serializable;

public final class MathDouble
implements FieldMember,
Serializable {
    private double x;

    public MathDouble(double d) {
        this.x = d;
    }

    public MathDouble(String string) throws NumberFormatException {
        this.x = Double.valueOf(string);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof MathDouble) {
            return Math.abs(this.x - ((MathDouble)object).value()) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        return Double.toString(this.x);
    }

    public double value() {
        return this.x;
    }

    public boolean isNaN() {
        return this.x == Double.NaN;
    }

    public boolean isInfinite() {
        return this.x == Double.POSITIVE_INFINITY || this.x == Double.NEGATIVE_INFINITY;
    }

    public AbelianGroupMember negate() {
        return new MathDouble(-this.x);
    }

    public FieldMember inverse() {
        return new MathDouble(1.0 / this.x);
    }

    public AbelianGroupMember add(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof MathDouble) {
            return this.add((MathDouble)abelianGroupMember);
        }
        if (abelianGroupMember instanceof MathInteger) {
            return this.add(new MathDouble(((MathInteger)abelianGroupMember).value()));
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble add(MathDouble mathDouble) {
        return new MathDouble(this.x + mathDouble.value());
    }

    public AbelianGroupMember subtract(AbelianGroupMember abelianGroupMember) {
        if (abelianGroupMember instanceof MathDouble) {
            return this.subtract((MathDouble)abelianGroupMember);
        }
        if (abelianGroupMember instanceof MathInteger) {
            return this.subtract(new MathDouble(((MathInteger)abelianGroupMember).value()));
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble subtract(MathDouble mathDouble) {
        return new MathDouble(this.x - mathDouble.value());
    }

    public RingMember multiply(RingMember ringMember) {
        if (ringMember instanceof MathDouble) {
            return this.multiply((MathDouble)ringMember);
        }
        if (ringMember instanceof MathInteger) {
            return this.multiply(new MathDouble(((MathInteger)ringMember).value()));
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble multiply(MathDouble mathDouble) {
        return new MathDouble(this.x * mathDouble.value());
    }

    public FieldMember divide(FieldMember fieldMember) {
        if (fieldMember instanceof MathDouble) {
            return this.divide((MathDouble)fieldMember);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public MathDouble divide(MathDouble mathDouble) {
        return new MathDouble(this.x / mathDouble.value());
    }
}

