/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.ArrayMath;
import JSci.maths.Complex;

public final class WaveletMath
extends AbstractMath {
    private WaveletMath() {
    }

    public static Complex[] downsample(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        int n2 = Math.round((float)n / 2.0f - 0.5f);
        int n3 = complexArray2.length;
        int n4 = Math.round((float)n3 / 2.0f - 0.5f);
        Complex[] complexArray3 = new Complex[n4];
        int n5 = 0;
        while (n5 < n4) {
            complexArray3[n5] = Complex.ZERO;
            int n6 = Math.max(0, 2 * n5 - n2 + 1);
            while (n6 < Math.min(n3, 2 * n5 + n - n2 + 1)) {
                complexArray3[n5] = complexArray3[n5].add(complexArray2[n6].multiply(complexArray[n6 - 2 * n5 + n2 - 1]));
                ++n6;
            }
            ++n5;
        }
        return complexArray3;
    }

    public static double[] downsample(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = Math.round((float)n / 2.0f - 0.5f);
        int n3 = dArray2.length;
        int n4 = Math.round((float)n3 / 2.0f - 0.5f);
        double[] dArray3 = new double[n4];
        int n5 = 0;
        while (n5 < n4) {
            dArray3[n5] = 0.0;
            int n6 = Math.max(0, 2 * n5 - n2 + 1);
            while (n6 < Math.min(n3, 2 * n5 + n - n2 + 1)) {
                int n7 = n5;
                dArray3[n7] = dArray3[n7] + dArray2[n6] * dArray[n6 - 2 * n5 + n2 - 1];
                ++n6;
            }
            ++n5;
        }
        return dArray3;
    }

    public static Complex[] upsample(Complex[] complexArray) {
        int n = complexArray.length;
        Complex[] complexArray2 = new Complex[2 * n];
        int n2 = 0;
        while (n2 < n) {
            complexArray2[2 * n2] = complexArray[n2];
            complexArray2[2 * n2 + 1] = Complex.ZERO;
            ++n2;
        }
        return complexArray2;
    }

    public static double[] upsample(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[2 * n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[2 * n2] = dArray[n2];
            dArray2[2 * n2 + 1] = 0.0;
            ++n2;
        }
        return dArray2;
    }

    public static Complex[] upsample(Complex[] complexArray, Complex[] complexArray2) {
        int n = complexArray.length;
        int n2 = Math.round((float)n / 2.0f - 0.5f);
        int n3 = complexArray2.length;
        Complex[] complexArray3 = new Complex[2 * n3];
        Complex[] complexArray4 = new Complex[2 * n3];
        complexArray4 = WaveletMath.upsample(complexArray2);
        int n4 = 0;
        while (n4 < 2 * n3) {
            complexArray3[n4] = Complex.ZERO;
            int n5 = Math.max(0, n4 - n2);
            while (n5 < Math.min(2 * n3, n4 + n - n2)) {
                complexArray3[n4] = complexArray3[n4].add(complexArray4[n5].multiply(complexArray[n4 + n - n2 - n5 - 1]));
                ++n5;
            }
            ++n4;
        }
        return complexArray3;
    }

    public static double[] upsample(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        int n2 = Math.round((float)n / 2.0f - 0.5f);
        int n3 = dArray2.length;
        double[] dArray3 = new double[2 * n3];
        double[] dArray4 = new double[2 * n3];
        dArray4 = WaveletMath.upsample(dArray2);
        int n4 = 0;
        while (n4 < 2 * n3) {
            dArray3[n4] = 0.0;
            int n5 = Math.max(0, n4 - n2);
            while (n5 < Math.min(2 * n3, n4 + n - n2)) {
                int n6 = n4;
                dArray3[n6] = dArray3[n6] + dArray4[n5] * dArray[n4 + n - n2 - n5 - 1];
                ++n5;
            }
            ++n4;
        }
        return dArray3;
    }

    public static double[] lowToHigh(double[] dArray) {
        double[] dArray2 = ArrayMath.invert(dArray);
        int n = 1;
        int n2 = 0;
        while (n2 < dArray2.length) {
            dArray2[n2] = (double)n * dArray2[n2];
            n *= -1;
            ++n2;
        }
        return dArray2;
    }
}

