/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.SpecialMath;
import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class GammaDistribution
extends ProbabilityDistribution {
    private double a;

    public GammaDistribution(double d) {
        if (d <= 0.0) {
            throw new OutOfRangeException("The shape parameter should be (strictly) positive.");
        }
        this.a = d;
    }

    public double getShapeParameter() {
        return this.a;
    }

    public double probability(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        if (d == 0.0) {
            return 0.0;
        }
        return Math.exp(-SpecialMath.logGamma(this.a) - d + (this.a - 1.0) * Math.log(d));
    }

    public double cumulative(double d) {
        this.checkRange(d, 0.0, Double.MAX_VALUE);
        return SpecialMath.incompleteGamma(this.a, d);
    }

    public double inverse(double d) {
        this.checkRange(d);
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.MAX_VALUE;
        }
        return this.findRoot(d, this.a, 0.0, Double.MAX_VALUE);
    }
}

