/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.statistics.OutOfRangeException;

public abstract class ProbabilityDistribution {
    public abstract double probability(double var1);

    public abstract double cumulative(double var1);

    public abstract double inverse(double var1);

    protected void checkRange(double d, double d2, double d3) {
        if (d < d2 || d > d3) {
            throw new OutOfRangeException("The argument of the distribution method should be between " + d2 + " and " + d3 + ".");
        }
    }

    protected void checkRange(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException("The argument of the distribution method should be between 0 and 1.");
        }
    }

    protected double findRoot(double d, double d2, double d3, double d4) {
        double d5 = 1.0E-10;
        int n = 150;
        double d6 = d2;
        double d7 = d2;
        double d8 = 1000.0;
        int n2 = 0;
        while (Math.abs(d8) > d5 && n2++ < n) {
            double d9 = this.cumulative(d6) - d;
            if (d9 < 0.0) {
                d3 = d6;
            } else {
                d4 = d6;
            }
            double d10 = this.probability(d6);
            if (d10 != 0.0) {
                d8 = d9 / d10;
                d7 = d6 - d8;
            }
            if (d7 < d3 || d7 > d4 || d10 == 0.0) {
                d7 = (d3 + d4) / 2.0;
                d8 = d7 - d6;
            }
            d6 = d7;
        }
        return d6;
    }
}

