/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexDiagonalMatrix;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DimensionException;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public class ComplexSquareMatrix
extends ComplexMatrix {
    protected ComplexSquareMatrix() {
    }

    public ComplexSquareMatrix(int n) {
        super(n, n);
    }

    public ComplexSquareMatrix(Complex[][] complexArray) {
        super(complexArray);
        if (complexArray.length != complexArray[0].length) {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
    }

    public ComplexSquareMatrix(ComplexVector[] complexVectorArray) {
        super(complexVectorArray);
        if (complexVectorArray.length != complexVectorArray[0].dimension()) {
            this.matrix = null;
            throw new MatrixDimensionException("The array does not form a square matrix.");
        }
    }

    public boolean isHermitian() {
        return this.equals(this.hermitianAdjoint());
    }

    public boolean isUnitary() {
        return this.multiply(this.hermitianAdjoint()).equals(ComplexDiagonalMatrix.identity(this.matrix[0].length));
    }

    public Complex det() {
        if (this.matrix.length == 2) {
            return this.matrix[0][0].multiply(this.matrix[1][1]).subtract(this.matrix[0][1].multiply(this.matrix[1][0]));
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = this.luDecompose();
        Complex complex = complexSquareMatrixArray[1].matrix[0][0];
        int n = 1;
        while (n < this.matrix.length) {
            complex = complex.multiply(complexSquareMatrixArray[1].matrix[n][n]);
            ++n;
        }
        return complex;
    }

    public Complex trace() {
        double d = this.matrix[0][0].real();
        double d2 = this.matrix[0][0].imag();
        int n = 1;
        while (n < this.matrix.length) {
            d += this.matrix[0][n].real();
            d2 += this.matrix[0][n].imag();
            ++n;
        }
        return new Complex(d, d2);
    }

    public ComplexMatrix add(ComplexMatrix complexMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(complexMatrix);
            }
        }
        if (this.matrix.length == complexMatrix.rows() && this.matrix.length == complexMatrix.columns()) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].add(complexMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.matrix[n][n2].add(complexMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawAdd(ComplexMatrix complexMatrix) {
        if (this.matrix.length == complexMatrix.matrix.length && this.matrix.length == complexMatrix.matrix[0].length) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].add(complexMatrix.matrix[n][0]);
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.matrix[n][n2].add(complexMatrix.matrix[n][n2]);
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix add(ComplexSquareMatrix complexSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(complexSquareMatrix);
            }
        }
        if (this.matrix.length == complexSquareMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].subtract(complexSquareMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.matrix[n][n2].subtract(complexSquareMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix subtract(ComplexMatrix complexMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(complexMatrix);
            }
        }
        if (this.matrix.length == complexMatrix.rows() && this.matrix.length == complexMatrix.columns()) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].subtract(complexMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.matrix[n][n2].subtract(complexMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private ComplexSquareMatrix rawSubtract(ComplexMatrix complexMatrix) {
        if (this.matrix.length == complexMatrix.matrix.length && this.matrix.length == complexMatrix.matrix[0].length) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].subtract(complexMatrix.matrix[n][0]);
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.matrix[n][n2].subtract(complexMatrix.matrix[n][n2]);
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexSquareMatrix subtract(ComplexSquareMatrix complexSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(complexSquareMatrix);
            }
        }
        if (this.matrix.length == complexSquareMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n][0] = this.matrix[n][0].subtract(complexSquareMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.matrix[n][n2].subtract(complexSquareMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public ComplexMatrix scalarMultiply(Complex complex) {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = complex.multiply(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < complexArray.length) {
                complexArray[n][n2] = complex.multiply(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }

    public ComplexMatrix scalarMultiply(double d) {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = this.matrix[n][0].multiply(d);
            int n2 = 1;
            while (n2 < complexArray.length) {
                complexArray[n][n2] = this.matrix[n][n2].multiply(d);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }

    public ComplexVector multiply(ComplexVector complexVector) {
        if (this.matrix.length == complexVector.dimension()) {
            Complex[] complexArray = new Complex[this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                complexArray[n] = this.matrix[n][0].multiply(complexVector.getComponent(0));
                int n2 = 1;
                while (n2 < this.matrix.length) {
                    complexArray[n] = complexArray[n].add(this.matrix[n][n2].multiply(complexVector.getComponent(n2)));
                    ++n2;
                }
                ++n;
            }
            return new ComplexVector(complexArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public ComplexMatrix multiply(ComplexMatrix complexMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(complexMatrix);
            }
        }
        if (this.matrix[0].length == complexMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix.length][complexMatrix.columns()];
            int n = 0;
            while (n < complexArray.length) {
                int n2 = 0;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.matrix[n][0].multiply(complexMatrix.getElement(0, n2));
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        complexArray[n][n2] = complexArray[n][n2].add(this.matrix[n][n3].multiply(complexMatrix.getElement(n3, n2)));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexMatrix rawMultiply(ComplexMatrix complexMatrix) {
        if (this.matrix[0].length == complexMatrix.matrix.length) {
            Complex[][] complexArray = new Complex[this.matrix.length][complexMatrix.matrix[0].length];
            int n = 0;
            while (n < complexArray.length) {
                int n2 = 0;
                while (n2 < complexArray[0].length) {
                    complexArray[n][n2] = this.matrix[n][0].multiply(complexMatrix.matrix[0][n2]);
                    int n3 = 1;
                    while (n3 < this.matrix[0].length) {
                        complexArray[n][n2] = complexArray[n][n2].add(this.matrix[n][n3].multiply(complexMatrix.matrix[n3][n2]));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexMatrix(complexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexSquareMatrix multiply(ComplexSquareMatrix complexSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(complexSquareMatrix);
            }
        }
        if (this.matrix.length == complexSquareMatrix.rows()) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                int n2 = 0;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.matrix[n][0].multiply(complexSquareMatrix.getElement(0, n2));
                    int n3 = 1;
                    while (n3 < complexArray.length) {
                        complexArray[n][n2] = complexArray[n][n2].add(this.matrix[n][n3].multiply(complexSquareMatrix.getElement(n3, n2)));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private ComplexSquareMatrix rawMultiply(ComplexSquareMatrix complexSquareMatrix) {
        if (this.matrix.length == complexSquareMatrix.matrix.length) {
            Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
            int n = 0;
            while (n < complexArray.length) {
                int n2 = 0;
                while (n2 < complexArray.length) {
                    complexArray[n][n2] = this.matrix[n][0].multiply(complexSquareMatrix.matrix[0][n2]);
                    int n3 = 1;
                    while (n3 < complexArray.length) {
                        complexArray[n][n2] = complexArray[n][n2].add(this.matrix[n][n3].multiply(complexSquareMatrix.matrix[n3][n2]));
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new ComplexSquareMatrix(complexArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public ComplexMatrix hermitianAdjoint() {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[0][n] = this.matrix[n][0].conjugate();
            int n2 = 1;
            while (n2 < complexArray.length) {
                complexArray[n2][n] = this.matrix[n][n2].conjugate();
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }

    public ComplexMatrix conjugate() {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = this.matrix[n][0].conjugate();
            int n2 = 1;
            while (n2 < complexArray.length) {
                complexArray[n][n2] = this.matrix[n][n2].conjugate();
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }

    public Matrix transpose() {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < complexArray.length) {
                complexArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }

    public ComplexSquareMatrix inverse() {
        int n;
        int n2;
        Complex[][][] complexArray = new Complex[2][this.matrix.length][this.matrix.length];
        ComplexSquareMatrix[] complexSquareMatrixArray = this.luDecompose();
        complexArray[0][0][0] = Complex.ONE.divide(complexSquareMatrixArray[0].matrix[0][0]);
        complexArray[1][0][0] = Complex.ONE.divide(complexSquareMatrixArray[1].matrix[0][0]);
        int n3 = 1;
        while (n3 < this.matrix.length) {
            complexArray[0][n3][n3] = Complex.ONE.divide(complexSquareMatrixArray[0].matrix[n3][n3]);
            complexArray[1][n3][n3] = Complex.ONE.divide(complexSquareMatrixArray[1].matrix[n3][n3]);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.matrix.length - 1) {
            n2 = n3 + 1;
            while (n2 < this.matrix.length) {
                Complex complex;
                Complex complex2 = complex = Complex.ZERO;
                n = n3;
                while (n < n2) {
                    complex2 = complex2.subtract(complexSquareMatrixArray[0].matrix[n2][n].multiply(complexArray[0][n][n3]));
                    complex = complex.subtract(complexArray[1][n3][n].multiply(complexSquareMatrixArray[1].matrix[n][n2]));
                    ++n;
                }
                complexArray[0][n3][n2] = Complex.ZERO;
                complexArray[0][n2][n3] = complex2.divide(complexSquareMatrixArray[0].matrix[n2][n2]);
                complexArray[1][n2][n3] = Complex.ZERO;
                complexArray[1][n3][n2] = complex.divide(complexSquareMatrixArray[1].matrix[n2][n2]);
                ++n2;
            }
            ++n3;
        }
        Complex[][] complexArray2 = new Complex[this.matrix.length][this.matrix.length];
        n3 = 0;
        while (n3 < this.matrix.length) {
            n2 = 0;
            while (n2 < this.matrix.length) {
                complexArray2[n3][n2] = complexArray[1][n3][0].multiply(complexArray[0][0][n2]);
                n = 1;
                while (n < this.matrix.length) {
                    complexArray2[n3][n2] = complexArray2[n3][n2].add(complexArray[1][n3][n].multiply(complexArray[0][n][n2]));
                    ++n;
                }
                ++n2;
            }
            ++n3;
        }
        return new ComplexSquareMatrix(complexArray2);
    }

    public ComplexSquareMatrix[] luDecompose() {
        Complex[][][] complexArray = new Complex[2][this.matrix.length][this.matrix.length];
        complexArray[0][0][0] = Complex.ONE;
        int n = 1;
        while (n < this.matrix.length) {
            complexArray[0][n][n] = Complex.ONE;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.matrix.length) {
            int n3;
            Complex complex;
            n = 0;
            while (n <= n2) {
                complex = this.matrix[n][n2];
                n3 = 0;
                while (n3 < n) {
                    complex = complex.subtract(complexArray[0][n][n3].multiply(complexArray[1][n3][n2]));
                    ++n3;
                }
                complexArray[1][n2][n] = Complex.ZERO;
                complexArray[1][n][n2] = complex;
                ++n;
            }
            n = n2 + 1;
            while (n < this.matrix.length) {
                complex = this.matrix[n][n2];
                n3 = 0;
                while (n3 < n2) {
                    complex = complex.subtract(complexArray[0][n][n3].multiply(complexArray[1][n3][n2]));
                    ++n3;
                }
                complexArray[0][n2][n] = Complex.ZERO;
                complexArray[0][n][n2] = complex.divide(complexArray[1][n2][n2]);
                ++n;
            }
            ++n2;
        }
        ComplexSquareMatrix[] complexSquareMatrixArray = new ComplexSquareMatrix[]{new ComplexSquareMatrix(complexArray[0]), new ComplexSquareMatrix(complexArray[1])};
        return complexSquareMatrixArray;
    }

    public ComplexMatrix mapElements(Mapping mapping) {
        Complex[][] complexArray = new Complex[this.matrix.length][this.matrix.length];
        int n = 0;
        while (n < complexArray.length) {
            complexArray[n][0] = mapping.map(this.matrix[n][0]);
            int n2 = 1;
            while (n2 < complexArray.length) {
                complexArray[n][n2] = mapping.map(this.matrix[n][n2]);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }
}

