/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.MathSet;

public class DiscreteSet
implements MathSet {
    private String label;
    protected Object[] elements;

    protected DiscreteSet(String string) {
        this.label = string;
    }

    public DiscreteSet(String string, Object[] objectArray) {
        this(string);
        this.elements = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.elements, 0, objectArray.length);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof DiscreteSet && this.label.equals(object.toString());
    }

    public final String toString() {
        return this.label;
    }

    public final int size() {
        return this.elements.length;
    }

    public final Object getElement(int n) {
        return this.elements[n];
    }

    public MathSet union(MathSet mathSet) {
        int n;
        if (!(mathSet instanceof DiscreteSet)) {
            throw new IllegalArgumentException("Must be a discrete set.");
        }
        DiscreteSet discreteSet = (DiscreteSet)mathSet;
        Object[] objectArray = new Object[this.elements.length + discreteSet.elements.length];
        if (this.elements.length > discreteSet.elements.length) {
            n = 0;
            while (n < discreteSet.elements.length) {
                objectArray[n] = discreteSet.elements[n];
                ++n;
            }
            int n2 = 0;
            while (n2 < this.elements.length) {
                boolean bl = true;
                int n3 = 0;
                while (n3 < discreteSet.elements.length) {
                    if (this.elements[n2].equals(objectArray[n3])) {
                        bl = false;
                    }
                    ++n3;
                }
                if (bl) {
                    objectArray[n++] = this.elements[n2];
                }
                ++n2;
            }
        } else {
            n = 0;
            while (n < this.elements.length) {
                objectArray[n] = this.elements[n];
                ++n;
            }
            int n4 = 0;
            while (n4 < discreteSet.elements.length) {
                boolean bl = true;
                int n5 = 0;
                while (n5 < this.elements.length) {
                    if (discreteSet.elements[n4].equals(objectArray[n5])) {
                        bl = false;
                    }
                    ++n5;
                }
                if (bl) {
                    objectArray[n++] = discreteSet.elements[n4];
                }
                ++n4;
            }
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        return new DiscreteSet("(" + this.label + ") U (" + discreteSet.label + ")", objectArray2);
    }

    public MathSet intersect(MathSet mathSet) {
        Object[] objectArray;
        if (!(mathSet instanceof DiscreteSet)) {
            throw new IllegalArgumentException("Must be a discrete set.");
        }
        DiscreteSet discreteSet = (DiscreteSet)mathSet;
        int n = 0;
        if (this.elements.length > discreteSet.elements.length) {
            objectArray = new Object[this.elements.length];
            int n2 = 0;
            while (n2 < this.elements.length) {
                boolean bl = true;
                int n3 = 0;
                while (n3 < discreteSet.elements.length && bl) {
                    if (this.elements[n2].equals(discreteSet.elements[n3])) {
                        objectArray[n++] = this.elements[n2];
                        bl = false;
                    }
                    ++n3;
                }
                ++n2;
            }
        } else {
            objectArray = new Object[discreteSet.elements.length];
            int n4 = 0;
            while (n4 < discreteSet.elements.length) {
                boolean bl = true;
                int n5 = 0;
                while (n5 < this.elements.length && bl) {
                    if (discreteSet.elements[n4].equals(this.elements[n5])) {
                        objectArray[n++] = this.elements[n5];
                        bl = false;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray2.length);
        return new DiscreteSet("(" + this.label + ") I (" + discreteSet.label + ")", objectArray2);
    }
}

