/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.Complex3Vector;
import JSci.maths.ComplexVector;
import JSci.maths.DoubleVector;
import JSci.maths.Integer3Vector;
import JSci.maths.IntegerVector;
import JSci.maths.Mapping;
import JSci.maths.MathVector;
import JSci.maths.VectorDimensionException;

public class Double3Vector
extends DoubleVector {
    public Double3Vector() {
        super(3);
    }

    public Double3Vector(double d, double d2, double d3) {
        super(3);
        this.vector[0] = d;
        this.vector[1] = d2;
        this.vector[2] = d3;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Double3Vector) {
            Double3Vector double3Vector = (Double3Vector)object;
            return Math.abs(this.vector[0] - double3Vector.vector[0]) <= GlobalSettings.ZERO_TOL && Math.abs(this.vector[1] - double3Vector.vector[1]) <= GlobalSettings.ZERO_TOL && Math.abs(this.vector[2] - double3Vector.vector[2]) <= GlobalSettings.ZERO_TOL;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.vector[0]).append(',').append(this.vector[1]).append(',').append(this.vector[2]);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public IntegerVector toIntegerVector() {
        return new Integer3Vector(Math.round((float)this.vector[0]), Math.round((float)this.vector[1]), Math.round((float)this.vector[2]));
    }

    public ComplexVector toComplexVector() {
        return new Complex3Vector(new Complex(this.vector[0], 0.0), new Complex(this.vector[1], 0.0), new Complex(this.vector[2], 0.0));
    }

    public double getComponent(int n) {
        if (n >= 0 && n < 3) {
            return this.vector[n];
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public void setComponent(int n, double d) {
        if (n >= 0 && n < 3) {
            this.vector[n] = d;
            return;
        }
        throw new VectorDimensionException("Invalid component.");
    }

    public int dimension() {
        return 3;
    }

    public double norm(int n) {
        double d = Math.pow(this.vector[0], n) + Math.pow(this.vector[1], n) + Math.pow(this.vector[2], n);
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.vector[0] * this.vector[0] + this.vector[1] * this.vector[1] + this.vector[2] * this.vector[2];
        return Math.sqrt(d);
    }

    public double infNorm() {
        double d = this.vector[0];
        if (this.vector[1] > d) {
            d = this.vector[1];
        }
        if (this.vector[2] > d) {
            d = this.vector[2];
        }
        return d;
    }

    public MathVector add(MathVector mathVector) {
        if (mathVector instanceof Double3Vector) {
            return this.add((Double3Vector)mathVector);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public Double3Vector add(Double3Vector double3Vector) {
        return new Double3Vector(this.vector[0] + double3Vector.vector[0], this.vector[1] + double3Vector.vector[1], this.vector[2] + double3Vector.vector[2]);
    }

    public MathVector subtract(MathVector mathVector) {
        if (mathVector instanceof Double3Vector) {
            return this.subtract((Double3Vector)mathVector);
        }
        throw new IllegalArgumentException("Vector class not recognised by this method.");
    }

    public Double3Vector subtract(Double3Vector double3Vector) {
        return new Double3Vector(this.vector[0] - double3Vector.vector[0], this.vector[1] - double3Vector.vector[1], this.vector[2] - double3Vector.vector[2]);
    }

    public DoubleVector scalarMultiply(double d) {
        return new Double3Vector(d * this.vector[0], d * this.vector[1], d * this.vector[2]);
    }

    public DoubleVector scalarDivide(double d) {
        return new Double3Vector(this.vector[0] / d, this.vector[1] / d, this.vector[2] / d);
    }

    public double scalarProduct(Double3Vector double3Vector) {
        return this.vector[0] * double3Vector.vector[0] + this.vector[1] * double3Vector.vector[1] + this.vector[2] * double3Vector.vector[2];
    }

    public Double3Vector multiply(Double3Vector double3Vector) {
        return new Double3Vector(this.vector[1] * double3Vector.vector[2] - double3Vector.vector[1] * this.vector[2], this.vector[2] * double3Vector.vector[0] - double3Vector.vector[2] * this.vector[0], this.vector[0] * double3Vector.vector[1] - double3Vector.vector[0] * this.vector[1]);
    }

    public DoubleVector mapComponents(Mapping mapping) {
        return new Double3Vector(mapping.map(this.vector[0]), mapping.map(this.vector[1]), mapping.map(this.vector[2]));
    }
}

