/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.GlobalSettings;
import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.DimensionException;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerSquareMatrix;
import JSci.maths.Mapping;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public final class DoubleSparseMatrix
extends DoubleSquareMatrix {
    protected static final int SPARSE = 2;
    protected static final int storageFormat = 2;
    private int[] colPos;
    private int[] rows;
    private int N;

    protected DoubleSparseMatrix() {
    }

    public DoubleSparseMatrix(int n) {
        this();
        this.N = n;
        this.matrix = new double[1][0];
        this.colPos = new int[0];
        this.rows = new int[this.N + 1];
    }

    protected void finalize() throws Throwable {
        this.colPos = null;
        this.rows = null;
        super.finalize();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof DoubleSparseMatrix && this.N == ((DoubleSparseMatrix)object).N) {
            DoubleSparseMatrix doubleSparseMatrix = (DoubleSparseMatrix)object;
            if (this.colPos.length != doubleSparseMatrix.colPos.length) {
                return false;
            }
            int n = 1;
            while (n < this.rows.length) {
                if (this.rows[n] != doubleSparseMatrix.rows[n]) {
                    return false;
                }
                ++n;
            }
            int n2 = 1;
            while (n2 < this.colPos.length) {
                if (this.colPos[n2] != doubleSparseMatrix.colPos[n2]) {
                    return false;
                }
                if (Math.abs(this.matrix[0][n2] - doubleSparseMatrix.matrix[0][n2]) > GlobalSettings.ZERO_TOL) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.N * this.N);
        int n = 0;
        while (n < this.N) {
            int n2 = 0;
            while (n2 < this.N) {
                stringBuffer.append(this.getElement(n, n2));
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    public IntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.N][this.N];
        int n = 0;
        while (n < this.N) {
            int n2 = 0;
            while (n2 < this.N) {
                nArray[n][n2] = Math.round((float)this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return new IntegerSquareMatrix(nArray);
    }

    public ComplexMatrix toComplexMatrix() {
        Complex[][] complexArray = new Complex[this.N][this.N];
        int n = 0;
        while (n < this.N) {
            int n2 = 0;
            while (n2 < this.N) {
                complexArray[n][n2] = new Complex(this.getElement(n, n2), 0.0);
                ++n2;
            }
            ++n;
        }
        return new ComplexSquareMatrix(complexArray);
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.N && n2 >= 0 && n2 < this.N) {
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    return this.matrix[0][n3];
                }
                ++n3;
            }
            return 0.0;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public void setElement(int n, int n2, double d) {
        if (n >= 0 && n < this.N && n2 >= 0 && n2 < this.N) {
            if (Math.abs(d) <= GlobalSettings.ZERO_TOL) {
                return;
            }
            int n3 = this.rows[n];
            while (n3 < this.rows[n + 1]) {
                if (this.colPos[n3] == n2) {
                    this.matrix[0][n3] = d;
                    return;
                }
                ++n3;
            }
            double[] dArray = this.matrix[0];
            int[] nArray = this.colPos;
            this.matrix[0] = new double[dArray.length + 1];
            this.colPos = new int[nArray.length + 1];
            System.arraycopy(dArray, 0, this.matrix[0], 0, this.rows[n]);
            System.arraycopy(nArray, 0, this.colPos, 0, this.rows[n]);
            n3 = this.rows[n];
            while (n3 < this.rows[n + 1] && nArray[n3] < n2) {
                this.matrix[0][n3] = dArray[n3];
                this.colPos[n3] = nArray[n3];
                ++n3;
            }
            this.matrix[0][n3] = d;
            this.colPos[n3] = n2;
            System.arraycopy(dArray, n3, this.matrix[0], n3 + 1, dArray.length - n3);
            System.arraycopy(nArray, n3, this.colPos, n3 + 1, nArray.length - n3);
            n3 = n + 1;
            while (n3 < this.rows.length) {
                int n4 = n3++;
                this.rows[n4] = this.rows[n4] + 1;
            }
            return;
        }
        throw new MatrixDimensionException("Invalid element.");
    }

    public double det() {
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose();
        double d = doubleSquareMatrixArray[1].matrix[0][0];
        int n = 1;
        while (n < this.N) {
            d *= doubleSquareMatrixArray[1].matrix[n][n];
            ++n;
        }
        return d;
    }

    public double trace() {
        double d = this.getElement(0, 0);
        int n = 1;
        while (n < this.N) {
            d += this.getElement(n, n);
            ++n;
        }
        return d;
    }

    public double infNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.N) {
            double d2 = 0.0;
            int n2 = this.rows[n];
            while (n2 < this.rows[n + 1]) {
                d2 += Math.abs(this.matrix[0][n2]);
                ++n2;
            }
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        int n = 0;
        while (n < this.colPos.length) {
            d += this.matrix[0][n] * this.matrix[0][n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public int rows() {
        return this.N;
    }

    public int columns() {
        return this.N;
    }

    public DoubleMatrix add(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(doubleMatrix);
            }
            case 2: {
                return this.add((DoubleSparseMatrix)doubleMatrix);
            }
        }
        if (this.N == doubleMatrix.rows() && this.N == doubleMatrix.columns()) {
            double[][] dArray = new double[this.N][this.N];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) + doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawAdd(DoubleMatrix doubleMatrix) {
        if (this.N == doubleMatrix.matrix.length && this.N == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.N][this.N];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) + doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix add(DoubleSquareMatrix doubleSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawAdd(doubleSquareMatrix);
            }
            case 2: {
                return this.add((DoubleSparseMatrix)doubleSquareMatrix);
            }
        }
        if (this.N == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.N][this.N];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) + doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) + doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix add(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.N == doubleSparseMatrix.N) {
            DoubleSparseMatrix doubleSparseMatrix2 = new DoubleSparseMatrix(this.N);
            int n = 0;
            while (n < this.N) {
                doubleSparseMatrix2.setElement(n, 0, this.getElement(n, 0) + doubleSparseMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < this.N) {
                    doubleSparseMatrix2.setElement(n, n2, this.getElement(n, n2) + doubleSparseMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix subtract(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(doubleMatrix);
            }
            case 2: {
                return this.subtract((DoubleSparseMatrix)doubleMatrix);
            }
        }
        if (this.N == doubleMatrix.rows() && this.N == doubleMatrix.columns()) {
            double[][] dArray = new double[this.N][this.N];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) - doubleMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private DoubleSquareMatrix rawSubtract(DoubleMatrix doubleMatrix) {
        if (this.N == doubleMatrix.matrix.length && this.N == doubleMatrix.matrix[0].length) {
            double[][] dArray = new double[this.N][this.N];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) - doubleMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSquareMatrix subtract(DoubleSquareMatrix doubleSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawSubtract(doubleSquareMatrix);
            }
            case 2: {
                return this.subtract((DoubleSparseMatrix)doubleSquareMatrix);
            }
        }
        if (this.N == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.N][this.N];
            int n = 0;
            while (n < dArray.length) {
                dArray[n][0] = this.getElement(n, 0) - doubleSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, n2) - doubleSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleSparseMatrix subtract(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.N == doubleSparseMatrix.N) {
            DoubleSparseMatrix doubleSparseMatrix2 = new DoubleSparseMatrix(this.N);
            int n = 0;
            while (n < this.N) {
                doubleSparseMatrix2.setElement(n, 0, this.getElement(n, 0) - doubleSparseMatrix.getElement(n, 0));
                int n2 = 1;
                while (n2 < this.N) {
                    doubleSparseMatrix2.setElement(n, n2, this.getElement(n, n2) - doubleSparseMatrix.getElement(n, n2));
                    ++n2;
                }
                ++n;
            }
            return doubleSparseMatrix2;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public DoubleMatrix scalarMultiply(double d) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.N);
        doubleSparseMatrix.matrix[0] = new double[this.matrix[0].length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseMatrix.matrix[0][n] = d * this.matrix[0][n];
            ++n;
        }
        return doubleSparseMatrix;
    }

    public DoubleVector multiply(DoubleVector doubleVector) {
        if (this.N == doubleVector.dimension()) {
            double[] dArray = new double[this.N];
            int n = 0;
            while (n < dArray.length) {
                int n2 = this.rows[n];
                while (n2 < this.rows[n + 1]) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + this.matrix[0][n2] * doubleVector.getComponent(this.colPos[n2]);
                    ++n2;
                }
                ++n;
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public DoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(doubleMatrix);
            }
            case 2: {
                return this.multiply((DoubleSparseMatrix)doubleMatrix);
            }
        }
        if (this.N == doubleMatrix.rows()) {
            double[][] dArray = new double[this.N][doubleMatrix.columns()];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.N) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleMatrix rawMultiply(DoubleMatrix doubleMatrix) {
        if (this.N == doubleMatrix.matrix.length) {
            double[][] dArray = new double[this.N][doubleMatrix.matrix[0].length];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray[0].length) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.N) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSquareMatrix multiply(DoubleSquareMatrix doubleSquareMatrix) {
        switch (1) {
            case 1: {
                return this.rawMultiply(doubleSquareMatrix);
            }
            case 2: {
                return this.multiply((DoubleSparseMatrix)doubleSquareMatrix);
            }
        }
        if (this.N == doubleSquareMatrix.rows()) {
            double[][] dArray = new double[this.N][this.N];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleSquareMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleSquareMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private DoubleSquareMatrix rawMultiply(DoubleSquareMatrix doubleSquareMatrix) {
        if (this.N == doubleSquareMatrix.matrix.length) {
            double[][] dArray = new double[this.N][this.N];
            int n = 0;
            while (n < dArray.length) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    dArray[n][n2] = this.getElement(n, 0) * doubleSquareMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < dArray.length) {
                        double[] dArray2 = dArray[n];
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + this.getElement(n, n3) * doubleSquareMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new DoubleSquareMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public DoubleSparseMatrix multiply(DoubleSparseMatrix doubleSparseMatrix) {
        if (this.N == doubleSparseMatrix.N) {
            DoubleSparseMatrix doubleSparseMatrix2 = new DoubleSparseMatrix(this.N);
            int n = 0;
            while (n < this.N) {
                int n2 = 0;
                while (n2 < this.N) {
                    double d = this.getElement(n, 0) * doubleSparseMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.N) {
                        d += this.getElement(n, n3) * doubleSparseMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    doubleSparseMatrix2.setElement(n, n2, d);
                    ++n2;
                }
                ++n;
            }
            return doubleSparseMatrix2;
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.N);
        int n = 0;
        while (n < this.N) {
            doubleSparseMatrix.setElement(0, n, this.getElement(n, 0));
            int n2 = 1;
            while (n2 < this.N) {
                doubleSparseMatrix.setElement(n2, n, this.getElement(n, n2));
                ++n2;
            }
            ++n;
        }
        return doubleSparseMatrix;
    }

    public DoubleSquareMatrix[] luDecompose() {
        double[][][] dArray = new double[2][this.N][this.N];
        dArray[0][0][0] = 1.0;
        int n = 1;
        while (n < dArray[0].length) {
            dArray[0][n][n] = 1.0;
            ++n;
        }
        int n2 = 0;
        while (n2 < dArray[0].length) {
            int n3;
            double d;
            n = 0;
            while (n <= n2) {
                d = this.getElement(n, n2);
                n3 = 0;
                while (n3 < n) {
                    d -= dArray[0][n][n3] * dArray[1][n3][n2];
                    ++n3;
                }
                dArray[1][n][n2] = d;
                ++n;
            }
            n = n2 + 1;
            while (n < dArray[0].length) {
                d = this.getElement(n, n2);
                n3 = 0;
                while (n3 < n2) {
                    d -= dArray[0][n][n3] * dArray[1][n3][n2];
                    ++n3;
                }
                dArray[0][n][n2] = d / dArray[1][n2][n2];
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public DoubleSquareMatrix[] choleskyDecompose() {
        double[][][] dArray = new double[2][this.N][this.N];
        double d = Math.sqrt(this.getElement(0, 0));
        dArray[1][0][0] = d;
        dArray[0][0][0] = d;
        int n = 1;
        while (n < dArray[0].length) {
            double d2 = this.getElement(n, 0) / dArray[0][0][0];
            dArray[1][0][n] = d2;
            dArray[0][n][0] = d2;
            ++n;
        }
        int n2 = 1;
        while (n2 < dArray[0].length) {
            double d3 = this.getElement(n2, n2);
            n = 0;
            while (n < n2) {
                d3 -= dArray[0][n2][n] * dArray[0][n2][n];
                ++n;
            }
            double d4 = Math.sqrt(d3);
            dArray[1][n2][n2] = d4;
            dArray[0][n2][n2] = d4;
            n = n2 + 1;
            while (n < dArray[0].length) {
                d3 = this.getElement(n, n2);
                int n3 = 0;
                while (n3 < n) {
                    d3 -= dArray[0][n2][n3] * dArray[1][n3][n];
                    ++n3;
                }
                double d5 = d3 / dArray[1][n2][n2];
                dArray[1][n2][n] = d5;
                dArray[0][n][n2] = d5;
                ++n;
            }
            ++n2;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray[0]), new DoubleSquareMatrix(dArray[1])};
        return doubleSquareMatrixArray;
    }

    public DoubleMatrix mapElements(Mapping mapping) {
        DoubleSparseMatrix doubleSparseMatrix = new DoubleSparseMatrix(this.N);
        doubleSparseMatrix.matrix[0] = new double[this.matrix[0].length];
        doubleSparseMatrix.colPos = new int[this.colPos.length];
        System.arraycopy(this.colPos, 0, doubleSparseMatrix.colPos, 0, this.colPos.length);
        System.arraycopy(this.rows, 0, doubleSparseMatrix.rows, 0, this.rows.length);
        int n = 0;
        while (n < this.colPos.length) {
            doubleSparseMatrix.matrix[0][n] = mapping.map(this.matrix[0][n]);
            ++n;
        }
        return doubleSparseMatrix;
    }
}

