/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.algebras;

import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexSquareMatrix;
import JSci.maths.Double3Vector;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.LieAlgebra;
import JSci.maths.fields.ComplexField;

public final class su2Dim3
extends LieAlgebra {
    private static final Complex[][] t1 = new Complex[][]{{Complex.ZERO, ComplexField.SQRT_HALF, Complex.ZERO}, {ComplexField.SQRT_HALF, Complex.ZERO, ComplexField.SQRT_HALF}, {Complex.ZERO, ComplexField.SQRT_HALF, Complex.ZERO}};
    private static final Complex[][] t2 = new Complex[][]{{Complex.ZERO, ComplexField.MINUS_SQRT_HALF_I, Complex.ZERO}, {ComplexField.SQRT_HALF_I, Complex.ZERO, ComplexField.MINUS_SQRT_HALF_I}, {Complex.ZERO, ComplexField.SQRT_HALF_I, Complex.ZERO}};
    private static final Complex[][] t3 = new Complex[][]{{Complex.ONE, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, Complex.ZERO}, {Complex.ZERO, Complex.ZERO, ComplexField.MINUS_ONE}};
    private static final ComplexSquareMatrix[] basisMatrices = new ComplexSquareMatrix[]{new ComplexSquareMatrix(t1), new ComplexSquareMatrix(t2), new ComplexSquareMatrix(t3)};
    private static final double[][] g;
    private static final DoubleSquareMatrix metricMatrix;

    public su2Dim3() {
        super("su(2) [3]");
    }

    public ComplexSquareMatrix getElement(DoubleVector doubleVector) {
        ComplexMatrix complexMatrix = basisMatrices[0].scalarMultiply(doubleVector.getComponent(0));
        complexMatrix = complexMatrix.add(basisMatrices[1].scalarMultiply(doubleVector.getComponent(1)));
        complexMatrix = complexMatrix.add(basisMatrices[2].scalarMultiply(doubleVector.getComponent(2)));
        return (ComplexSquareMatrix)complexMatrix.scalarMultiply(Complex.I);
    }

    public DoubleVector multiply(DoubleVector doubleVector, DoubleVector doubleVector2) {
        if (!(doubleVector instanceof Double3Vector) || !(doubleVector2 instanceof Double3Vector)) {
            throw new VectorDimensionException("Vectors must be 3-vectors.");
        }
        return ((Double3Vector)doubleVector2).multiply((Double3Vector)doubleVector);
    }

    public double killingForm(DoubleVector doubleVector, DoubleVector doubleVector2) {
        return doubleVector.scalarProduct(metricMatrix.multiply(doubleVector2));
    }

    public ComplexSquareMatrix[] basis() {
        return basisMatrices;
    }

    public DoubleSquareMatrix cartanMetric() {
        return metricMatrix;
    }

    static {
        double[][] dArrayArray = new double[3][];
        double[] dArray = new double[3];
        dArray[0] = -2.0;
        dArrayArray[0] = dArray;
        double[] dArray2 = new double[3];
        dArray2[1] = -2.0;
        dArrayArray[1] = dArray2;
        double[] dArray3 = new double[3];
        dArray3[2] = -2.0;
        dArrayArray[2] = dArray3;
        g = dArrayArray;
        metricMatrix = new DoubleSquareMatrix(g);
    }
}

