/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.chaos;

import JSci.maths.Complex;
import JSci.maths.NMapping;

public final class StandardMap
implements NMapping {
    private Complex k;

    public StandardMap(double d) {
        this.k = new Complex(d, 0.0);
    }

    public StandardMap(Complex complex) {
        this.k = complex;
    }

    public double[] map(double[] dArray) {
        double[] dArray2 = new double[2];
        dArray2[1] = dArray[1] + this.k.real() * Math.sin(dArray[0]);
        dArray2[0] = dArray[0] + dArray2[1];
        return dArray2;
    }

    public Complex[] map(Complex[] complexArray) {
        Complex[] complexArray2 = new Complex[2];
        complexArray2[1] = complexArray[1].add(this.k.multiply(Complex.sin(complexArray[0])));
        complexArray2[0] = complexArray[0].add(complexArray2[1]);
        return complexArray2;
    }

    public double[] iterate(int n, double[] dArray) {
        double[] dArray2 = this.map(dArray);
        int n2 = 1;
        while (n2 < n) {
            dArray2 = this.map(dArray2);
            ++n2;
        }
        return dArray2;
    }

    public Complex[] iterate(int n, Complex[] complexArray) {
        Complex[] complexArray2 = this.map(complexArray);
        int n2 = 1;
        while (n2 < n) {
            complexArray2 = this.map(complexArray2);
            ++n2;
        }
        return complexArray2;
    }
}

