/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.statistics;

import JSci.maths.SpecialMath;
import JSci.maths.statistics.OutOfRangeException;
import JSci.maths.statistics.ProbabilityDistribution;

public final class BetaDistribution
extends ProbabilityDistribution {
    private double p;
    private double q;

    public BetaDistribution(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new OutOfRangeException("The degrees of freedom must be greater than zero.");
        }
        this.p = d;
        this.q = d2;
    }

    public double getDegreesOfFreedomP() {
        return this.p;
    }

    public double getDegreesOfFreedomQ() {
        return this.q;
    }

    public double probability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException("The argument of the distribution method should be between 0 and 1.");
        }
        if (d == 0.0 || d == 1.0) {
            return 0.0;
        }
        return Math.exp(-SpecialMath.logBeta(this.p, this.q) + (this.p - 1.0) * Math.log(d) + (this.q - 1.0) * Math.log(1.0 - d));
    }

    public double cumulative(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException("The argument of the distribution method should be between 0 and 1.");
        }
        return SpecialMath.incompleteBeta(d, this.p, this.q);
    }

    public double inverse(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new OutOfRangeException("The argument of the distribution method should be between 0 and 1.");
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        return this.findRoot(d, 0.5, 0.0, 1.0);
    }
}

