/*
 * Decompiled with CFR 0.152.
 */
package JSci.beans;

import JSci.beans.VariableEvent;
import JSci.beans.VariableListener;
import JSci.io.MathMLExpression;
import JSci.io.MathMLParser;
import JSci.maths.Complex;
import JSci.maths.ComplexMatrix;
import JSci.maths.ComplexVector;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.util.MatrixToolkit;
import JSci.util.VectorToolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public final class MathBean
implements Serializable,
VariableListener,
ActionListener {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private MathMLExpression expr;
    private String mathml = new String();
    private Hashtable variables = new Hashtable();
    private Object result = new MathDouble(Double.NaN);

    public void setMathML(String string) {
        Object object;
        try {
            object = new MathMLParser();
            object.parse(string);
            this.expr = (MathMLExpression)object.getJSciObjects()[0];
        }
        catch (Exception exception) {}
        object = this.mathml;
        this.mathml = string;
        this.changes.firePropertyChange("mathml", object, string);
    }

    public String getMathML() {
        return this.mathml;
    }

    public double getResultAs0DArray() {
        if (this.result instanceof MathDouble) {
            return ((MathDouble)this.result).value();
        }
        if (this.result instanceof MathInteger) {
            return ((MathInteger)this.result).value();
        }
        return Double.NaN;
    }

    public double[] getResultAs1DArray() {
        if (this.result instanceof Complex) {
            double[] dArray = new double[]{((Complex)this.result).real(), ((Complex)this.result).imag()};
            return dArray;
        }
        if (this.result instanceof DoubleVector) {
            return VectorToolkit.toArray((DoubleVector)((DoubleVector)this.result));
        }
        if (this.result instanceof IntegerVector) {
            return VectorToolkit.toArray((DoubleVector)((IntegerVector)this.result).toDoubleVector());
        }
        return null;
    }

    public double[][] getResultAs2DArray() {
        if (this.result instanceof ComplexVector) {
            double[][] dArray = new double[][]{VectorToolkit.toArray((DoubleVector)((ComplexVector)this.result).real()), VectorToolkit.toArray((DoubleVector)((ComplexVector)this.result).imag())};
            return dArray;
        }
        if (this.result instanceof DoubleMatrix) {
            return MatrixToolkit.toArray((DoubleMatrix)((DoubleMatrix)this.result));
        }
        if (this.result instanceof IntegerMatrix) {
            return MatrixToolkit.toArray((DoubleMatrix)((IntegerMatrix)this.result).toDoubleMatrix());
        }
        return null;
    }

    public double[][][] getResultAs3DArray() {
        if (this.result instanceof ComplexMatrix) {
            double[][][] dArray = new double[][][]{MatrixToolkit.toArray((DoubleMatrix)((ComplexMatrix)this.result).real()), MatrixToolkit.toArray((DoubleMatrix)((ComplexMatrix)this.result).imag())};
            return dArray;
        }
        return null;
    }

    public void variableChanged(VariableEvent variableEvent) {
        this.variables.put(variableEvent.getVariable(), variableEvent.getValue());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MathMLExpression mathMLExpression = this.expr;
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            mathMLExpression = mathMLExpression.substitute(k.toString(), this.variables.get(k));
        }
        this.result = mathMLExpression.evaluate();
        this.changes.firePropertyChange("resultAs0DArray", null, new Double(this.getResultAs0DArray()));
        this.changes.firePropertyChange("resultAs1DArray", null, this.getResultAs1DArray());
        this.changes.firePropertyChange("resultAs2DArray", null, this.getResultAs2DArray());
        this.changes.firePropertyChange("resultAs3DArray", null, this.getResultAs3DArray());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }
}

