/*
 * Decompiled with CFR 0.152.
 */
package JSci.beans;

import JSci.beans.VariableEvent;
import JSci.beans.VariableListener;
import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.MathDouble;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;

public final class VariableBean
implements Serializable {
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private Vector variableListeners = new Vector();
    private String variable = new String();
    private Object value;

    public void setVariable(String string) {
        String string2 = this.variable;
        this.variable = string;
        this.changes.firePropertyChange("variable", string2, string);
    }

    public String getVariable() {
        return this.variable;
    }

    public void setValueAsNumber(double d) {
        this.value = new MathDouble(d);
        this.changes.firePropertyChange("valueAsNumber", null, new Double(d));
        this.fireVariableChanged(new VariableEvent(this, this.variable, this.value));
    }

    public double getValueAsNumber() {
        if (this.value instanceof MathDouble) {
            return ((MathDouble)this.value).value();
        }
        return Double.NaN;
    }

    public void setValueAsVector(double[] dArray) {
        this.value = new DoubleVector(dArray);
        this.changes.firePropertyChange("valueAsVector", null, dArray);
        this.fireVariableChanged(new VariableEvent(this, this.variable, this.value));
    }

    public void setValueAsMatrix(double[][] dArray) {
        this.value = new DoubleMatrix(dArray);
        this.changes.firePropertyChange("valueAsMatrix", null, dArray);
        this.fireVariableChanged(new VariableEvent(this, this.variable, this.value));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void addVariableListener(VariableListener variableListener) {
        this.variableListeners.addElement(variableListener);
    }

    public void removeVariableListener(VariableListener variableListener) {
        this.variableListeners.removeElement(variableListener);
    }

    private void fireVariableChanged(VariableEvent variableEvent) {
        int n = 0;
        while (n < this.variableListeners.size()) {
            ((VariableListener)this.variableListeners.elementAt(n)).variableChanged(variableEvent);
            ++n;
        }
    }
}

