package JSci.chemistry;

/**
* A class representing chemical elements.
* @version 1.5
* @author Mark Hale
*/
public abstract class Element extends Object implements java.io.Serializable {
        /**
        * Constructs an element.
        */
        public Element() {}
        /**
        * Returns the atomic number.
        */
        public abstract int atomicNumber();
        /**
        * Returns the mass number.
        */
        public abstract int massNumber();
        /**
        * Returns the electronegativity.
        */
        public abstract double electronegativity();
        /**
        * Returns the covalent radius.
        */
        public abstract double covalentRadius();
        /**
        * Returns the atomic radius.
        */
        public abstract double atomicRadius();
        /**
        * Returns the melting point (K).
        */
        public abstract double meltingPoint();
        /**
        * Returns the boiling point (K).
        */
        public abstract double boilingPoint();
        /**
        * Returns the density (293K).
        */
        public abstract double density();
        /**
        * Returns the specific heat.
        */
        public abstract double specificHeat();
        /**
        * Returns the electrical conductivity.
        */
        public abstract double electricalConductivity();
        /**
        * Returns the thermal conductivity.
        */
        public abstract double thermalConductivity();
        /**
        * Compares two elements for equality.
        * @param e an element
        */
        public boolean equals(Object e) {
                return (e!=null) && (e instanceof Element) &&
                        (atomicNumber()==((Element)e).atomicNumber()) &&
                        (massNumber()==((Element)e).massNumber());
        }
}

