package JSci.chemistry.periodictable;

/**
* A class representing actinium.
* @version 1.5
* @author Mark Hale
*/
public final class Actinium extends TransitionMetal {
        /**
        * Constructs Actinium.
        */
        public Actinium() {}
        /**
        * Returns the atomic number.
        * @return 89
        */
        public int atomicNumber() {return 89;}
        /**
        * Returns the mass number.
        * @return 227
        */
        public int massNumber() {return 227;}
        /**
        * Returns the electronegativity.
        * @return 1.1
        */
        public double electronegativity() {return 1.1;}
        /**
        * Returns the covalent radius.
        * @return unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 1323
        */
        public double meltingPoint() {return 1323;}
        /**
        * Returns the boiling point.
        * @return 3473
        */
        public double boilingPoint() {return 3473;}
        /**
        * Returns the density (293K).
        * @return 10.07
        */
        public double density() {return 10.07;}
        /**
        * Returns the specific heat.
        * @return unknown
        */
        public double specificHeat() {return Double.NaN;}
        /**
        * Returns the electrical conductivity.
        * @return unknown
        */
        public double electricalConductivity() {return Double.NaN;}
        /**
        * Returns the thermal conductivity.
        * @return 0.12
        */
        public double thermalConductivity() {return 0.12;}
        /**
        * Returns the chemical symbol.
        * @return Ac
        */
        public String toString() {
                return new String("Ac");
        }
}

