package JSci.chemistry.periodictable;

/**
* A class representing americium.
* @version 1.5
* @author Mark Hale
*/
public final class Americium extends RareEarthMetal {
        /**
        * Constructs americium.
        */
        public Americium() {}
        /**
        * Returns the atomic number.
        * @return 95
        */
        public int atomicNumber() {return 95;}
        /**
        * Returns the mass number.
        * @return 243
        */
        public int massNumber() {return 243;}
        /**
        * Returns the electronegativity.
        * @return 1.3
        */
        public double electronegativity() {return 1.3;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 1268
        */
        public double meltingPoint() {return 1268;}
        /**
        * Returns the boiling point.
        * @return 2880
        */
        public double boilingPoint() {return 2880;}
        /**
        * Returns the density (293K).
        * @return 13.6
        */
        public double density() {return 13.6;}
        /**
        * Returns the specific heat.
        * @return 0.11
        */
        public double specificHeat() {return 0.11;}
        /**
        * Returns the electrical conductivity.
        * @return 0.022e6
        */
        public double electricalConductivity() {return 0.022e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.1
        */
        public double thermalConductivity() {return 0.1;}
        /**
        * Returns the chemical symbol.
        * @return Am
        */
        public String toString() {
                return new String("Am");
        }
}

