package JSci.chemistry.periodictable;

/**
* A class representing argon.
* @version 1.5
* @author Mark Hale
*/
public final class Argon extends NobleGas {
        /**
        * Constructs argon.
        */
        public Argon() {}
        /**
        * Returns the atomic number.
        * @return 18
        */
        public int atomicNumber() {return 18;}
        /**
        * Returns the mass number.
        * @return 40
        */
        public int massNumber() {return 40;}
        /**
        * Returns the electronegativity.
        * @return 0.0
        */
        public double electronegativity() {return 0.0;}
        /**
        * Returns the covalent radius.
        * @return 0.98
        */
        public double covalentRadius() {return 0.98;}
        /**
        * Returns the atomic radius.
        * @return 0.88
        */
        public double atomicRadius() {return 0.88;}
        /**
        * Returns the melting point.
        * @return 83.81
        */
        public double meltingPoint() {return 83.81;}
        /**
        * Returns the boiling point.
        * @return 87.3
        */
        public double boilingPoint() {return 87.3;}
        /**
        * Returns the density (293K).
        * @return 0.0017824
        */
        public double density() {return 0.0017824;}
        /**
        * Returns the specific heat.
        * @return 0.520
        */
        public double specificHeat() {return 0.520;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.0001772
        */
        public double thermalConductivity() {return 0.0001772;}
        /**
        * Returns the chemical symbol.
        * @return Ar
        */
        public String toString() {
                return new String("Ar");
        }
}

