package JSci.chemistry.periodictable;

/**
* A class representing arsenic.
* @version 1.5
* @author Mark Hale
*/
public final class Arsenic extends NonMetal {
        /**
        * Constructs arsenic.
        */
        public Arsenic() {}
        /**
        * Returns the atomic number.
        * @return 33
        */
        public int atomicNumber() {return 33;}
        /**
        * Returns the mass number.
        * @return 75
        */
        public int massNumber() {return 75;}
        /**
        * Returns the electronegativity.
        * @return 2.18
        */
        public double electronegativity() {return 2.18;}
        /**
        * Returns the covalent radius.
        * @return 1.21
        */
        public double covalentRadius() {return 1.21;}
        /**
        * Returns the atomic radius.
        * @return 1.33
        */
        public double atomicRadius() {return 1.33;}
        /**
        * Returns the melting point.
        * @return 1081
        */
        public double meltingPoint() {return 1081;}
        /**
        * Returns the boiling point.
        * @return 876
        */
        public double boilingPoint() {return 876;}
        /**
        * Returns the density (293K).
        * @return 5.72
        */
        public double density() {return 5.72;}
        /**
        * Returns the specific heat.
        * @return 0.33
        */
        public double specificHeat() {return 0.33;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0345e6
        */
        public double electricalConductivity() {return 0.0345e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.5
        */
        public double thermalConductivity() {return 0.5;}
        /**
        * Returns the chemical symbol.
        * @return As
        */
        public String toString() {
                return new String("As");
        }
}

