package JSci.chemistry.periodictable;

/**
* A class representing astatine.
* @version 1.5
* @author Mark Hale
*/
public final class Astatine extends Halogen {
        /**
        * Constructs astatine.
        */
        public Astatine() {}
        /**
        * Returns the atomic number.
        * @return 85
        */
        public int atomicNumber() {return 85;}
        /**
        * Returns the mass number.
        * @return 210
        */
        public int massNumber() {return 210;}
        /**
        * Returns the electronegativity.
        * @return 2.2
        */
        public double electronegativity() {return 2.2;}
        /**
        * Returns the covalent radius.
        * @return 1.45
        */
        public double covalentRadius() {return 1.45;}
        /**
        * Returns the atomic radius.
        * @return 1.43
        */
        public double atomicRadius() {return 1.43;}
        /**
        * Returns the melting point.
        * @return 575
        */
        public double meltingPoint() {return 575;}
        /**
        * Returns the boiling point.
        * @return 610
        */
        public double boilingPoint() {return 610;}
        /**
        * Returns the density (293K).
        * @return Unknown
        */
        public double density() {return Double.NaN;}
        /**
        * Returns the specific heat.
        * @return Unknown
        */
        public double specificHeat() {return Double.NaN;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.017
        */
        public double thermalConductivity() {return 0.017;}
        /**
        * Returns the chemical symbol.
        * @return At
        */
        public String toString() {
                return new String("At");
        }
}

