package JSci.chemistry.periodictable;

/**
* A class representing beryllium.
* @version 1.5
* @author Mark Hale
*/
public final class Beryllium extends AlkaliEarthMetal {
        /**
        * Constructs beryllium.
        */
        public Beryllium() {}
        /**
        * Returns the atomic number.
        * @return 4
        */
        public int atomicNumber() {return 4;}
        /**
        * Returns the mass number.
        * @return 9
        */
        public int massNumber() {return 9;}
        /**
        * Returns the electronegativity.
        * @return 1.57
        */
        public double electronegativity() {return 1.57;}
        /**
        * Returns the covalent radius.
        * @return 0.9
        */
        public double covalentRadius() {return 0.9;}
        /**
        * Returns the atomic radius.
        * @return 1.4
        */
        public double atomicRadius() {return 1.4;}
        /**
        * Returns the melting point.
        * @return 1560
        */
        public double meltingPoint() {return 1560;}
        /**
        * Returns the boiling point.
        * @return 2745
        */
        public double boilingPoint() {return 2745;}
        /**
        * Returns the density (293K).
        * @return 1.848
        */
        public double density() {return 1.848;}
        /**
        * Returns the specific heat.
        * @return 1.82
        */
        public double specificHeat() {return 1.82;}
        /**
        * Returns the electrical conductivity.
        * @return 0.313e6
        */
        public double electricalConductivity() {return 0.313e6;}
        /**
        * Returns the thermal conductivity.
        * @return 2.0
        */
        public double thermalConductivity() {return 2.0;}
        /**
        * Returns the chemical symbol.
        * @return Be
        */
        public String toString() {
                return new String("Be");
        }
}

