package JSci.chemistry.periodictable;

/**
* A class representing cadmium.
* @version 1.5
* @author Mark Hale
*/
public final class Cadmium extends TransitionMetal {
        /**
        * Constructs cadmium.
        */
        public Cadmium() {}
        /**
        * Returns the atomic number.
        * @return 48
        */
        public int atomicNumber() {return 48;}
        /**
        * Returns the mass number.
        * @return 112
        */
        public int massNumber() {return 112;}
        /**
        * Returns the electronegativity.
        * @return 1.69
        */
        public double electronegativity() {return 1.69;}
        /**
        * Returns the covalent radius.
        * @return 1.41
        */
        public double covalentRadius() {return 1.41;}
        /**
        * Returns the atomic radius.
        * @return 1.71
        */
        public double atomicRadius() {return 1.71;}
        /**
        * Returns the melting point.
        * @return 564.18
        */
        public double meltingPoint() {return 594.18;}
        /**
        * Returns the boiling point.
        * @return 1040
        */
        public double boilingPoint() {return 1040;}
        /**
        * Returns the density (293K).
        * @return 8.65
        */
        public double density() {return 8.65;}
        /**
        * Returns the specific heat.
        * @return 0.23
        */
        public double specificHeat() {return 0.23;}
        /**
        * Returns the electrical conductivity.
        * @return 0.138e6
        */
        public double electricalConductivity() {return 0.138e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.968
        */
        public double thermalConductivity() {return 0.968;}
        /**
        * Returns the chemical symbol.
        * @return Cd
        */
        public String toString() {
                return new String("Cd");
        }
}

