package JSci.chemistry.periodictable;

/**
* A class representing calcium.
* @version 1.5
* @author Mark Hale
*/
public final class Calcium extends AlkaliEarthMetal {
        /**
        * Constructs calcium.
        */
        public Calcium() {}
        /**
        * Returns the atomic number.
        * @return 20
        */
        public int atomicNumber() {return 20;}
        /**
        * Returns the mass number.
        * @return 40
        */
        public int massNumber() {return 40;}
        /**
        * Returns the electronegativity.
        * @return 1.00
        */
        public double electronegativity() {return 1.00;}
        /**
        * Returns the covalent radius.
        * @return 1.74
        */
        public double covalentRadius() {return 1.74;}
        /**
        * Returns the atomic radius.
        * @return 2.23
        */
        public double atomicRadius() {return 2.23;}
        /**
        * Returns the melting point.
        * @return 1112
        */
        public double meltingPoint() {return 1112;}
        /**
        * Returns the boiling point.
        * @return 1757
        */
        public double boilingPoint() {return 1757;}
        /**
        * Returns the density (293K).
        * @return 1.55
        */
        public double density() {return 1.55;}
        /**
        * Returns the specific heat.
        * @return 0.63
        */
        public double specificHeat() {return 0.63;}
        /**
        * Returns the electrical conductivity.
        * @return 0.298e6
        */
        public double electricalConductivity() {return 0.298e6;}
        /**
        * Returns the thermal conductivity.
        * @return 2.0
        */
        public double thermalConductivity() {return 2.0;}
        /**
        * Returns the chemical symbol.
        * @return Ca
        */
        public String toString() {
                return new String("Ca");
        }
}

