package JSci.chemistry.periodictable;

/**
* A class representing chlorine.
* @version 1.5
* @author Mark Hale
*/
public final class Chlorine extends Halogen {
        /**
        * Constructs chlorine.
        */
        public Chlorine() {}
        /**
        * Returns the atomic number.
        * @return 17
        */
        public int atomicNumber() {return 17;}
        /**
        * Returns the mass number.
        * @return 35
        */
        public int massNumber() {return 35;}
        /**
        * Returns the electronegativity.
        * @return 3.16
        */
        public double electronegativity() {return 3.16;}
        /**
        * Returns the covalent radius.
        * @return 0.99
        */
        public double covalentRadius() {return 0.99;}
        /**
        * Returns the atomic radius.
        * @return 0.97
        */
        public double atomicRadius() {return 0.97;}
        /**
        * Returns the melting point.
        * @return 172.16
        */
        public double meltingPoint() {return 172.16;}
        /**
        * Returns the boiling point.
        * @return 239.1
        */
        public double boilingPoint() {return 239.1;}
        /**
        * Returns the density (293K).
        * @return 0.003214
        */
        public double density() {return 0.003214;}
        /**
        * Returns the specific heat.
        * @return 0.48
        */
        public double specificHeat() {return 0.48;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.089e-3
        */
        public double thermalConductivity() {return 0.089e-3;}
        /**
        * Returns the chemical symbol.
        * @return Cl
        */
        public String toString() {
                return new String("Cl");
        }
}

