package JSci.chemistry.periodictable;

/**
* A class representing curium.
* @version 1.5
* @author Mark Hale
*/
public final class Curium extends RareEarthMetal {
        /**
        * Constructs curium.
        */
        public Curium() {}
        /**
        * Returns the atomic number.
        * @return 96
        */
        public int atomicNumber() {return 96;}
        /**
        * Returns the mass number.
        * @return 247
        */
        public int massNumber() {return 247;}
        /**
        * Returns the electronegativity.
        * @return 1.3
        */
        public double electronegativity() {return 1.3;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return 1340
        */
        public double meltingPoint() {return 1340;}
        /**
        * Returns the boiling point.
        * @return Unknown
        */
        public double boilingPoint() {return Double.NaN;}
        /**
        * Returns the density (293K).
        * @return 13.51
        */
        public double density() {return 13.51;}
        /**
        * Returns the specific heat.
        * @return Unknown
        */
        public double specificHeat() {return Double.NaN;}
        /**
        * Returns the electrical conductivity.
        * @return Unknown
        */
        public double electricalConductivity() {return Double.NaN;}
        /**
        * Returns the thermal conductivity.
        * @return 0.1
        */
        public double thermalConductivity() {return 0.1;}
        /**
        * Returns the chemical symbol.
        * @return Cm
        */
        public String toString() {
                return new String("Cm");
        }
}

