package JSci.chemistry.periodictable;

/**
* A class representing dysprosium.
* @version 1.5
* @author Mark Hale
*/
public final class Dysprosium extends RareEarthMetal {
        /**
        * Constructs dysprosium.
        */
        public Dysprosium() {}
        /**
        * Returns the atomic number.
        * @return 66
        */
        public int atomicNumber() {return 66;}
        /**
        * Returns the mass number.
        * @return 162
        */
        public int massNumber() {return 162;}
        /**
        * Returns the electronegativity.
        * @return 1.22
        */
        public double electronegativity() {return 1.22;}
        /**
        * Returns the covalent radius.
        * @return 1.59
        */
        public double covalentRadius() {return 1.59;}
        /**
        * Returns the atomic radius.
        * @return 2.49
        */
        public double atomicRadius() {return 2.49;}
        /**
        * Returns the melting point.
        * @return 1682
        */
        public double meltingPoint() {return 1682;}
        /**
        * Returns the boiling point.
        * @return 2835
        */
        public double boilingPoint() {return 2835;}
        /**
        * Returns the density (293K).
        * @return 8.536
        */
        public double density() {return 8.536;}
        /**
        * Returns the specific heat.
        * @return 0.17
        */
        public double specificHeat() {return 0.17;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0108e6
        */
        public double electricalConductivity() {return 0.0108e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.107
        */
        public double thermalConductivity() {return 0.107;}
        /**
        * Returns the chemical symbol.
        * @return Dy
        */
        public String toString() {
                return new String("Dy");
        }
}

