package JSci.chemistry.periodictable;

/**
* A class representing einsteinium.
* @version 1.5
* @author Mark Hale
*/
public final class Einsteinium extends RareEarthMetal {
        /**
        * Constructs einsteinium.
        */
        public Einsteinium() {}
        /**
        * Returns the atomic number.
        * @return 99
        */
        public int atomicNumber() {return 99;}
        /**
        * Returns the mass number.
        * @return 254
        */
        public int massNumber() {return 254;}
        /**
        * Returns the electronegativity.
        * @return 1.3
        */
        public double electronegativity() {return 1.3;}
        /**
        * Returns the covalent radius.
        * @return Unknown
        */
        public double covalentRadius() {return Double.NaN;}
        /**
        * Returns the atomic radius.
        * @return Unknown
        */
        public double atomicRadius() {return Double.NaN;}
        /**
        * Returns the melting point.
        * @return Unknown
        */
        public double meltingPoint() {return Double.NaN;}
        /**
        * Returns the boiling point.
        * @return Unknown
        */
        public double boilingPoint() {return Double.NaN;}
        /**
        * Returns the density (293K).
        * @return Unknown
        */
        public double density() {return Double.NaN;}
        /**
        * Returns the specific heat.
        * @return Unknown
        */
        public double specificHeat() {return Double.NaN;}
        /**
        * Returns the electrical conductivity.
        * @return Unknown
        */
        public double electricalConductivity() {return Double.NaN;}
        /**
        * Returns the thermal conductivity.
        * @return 0.1
        */
        public double thermalConductivity() {return 0.1;}
        /**
        * Returns the chemical symbol.
        * @return Es
        */
        public String toString() {
                return new String("Es");
        }
}

