package JSci.chemistry.periodictable;

/**
* A class representing erbium.
* @version 1.5
* @author Mark Hale
*/
public final class Erbium extends RareEarthMetal {
        /**
        * Constructs erbium.
        */
        public Erbium() {}
        /**
        * Returns the atomic number.
        * @return 68
        */
        public int atomicNumber() {return 68;}
        /**
        * Returns the mass number.
        * @return 167
        */
        public int massNumber() {return 167;}
        /**
        * Returns the electronegativity.
        * @return 1.24
        */
        public double electronegativity() {return 1.24;}
        /**
        * Returns the covalent radius.
        * @return 1.57
        */
        public double covalentRadius() {return 1.57;}
        /**
        * Returns the atomic radius.
        * @return 2.45
        */
        public double atomicRadius() {return 2.45;}
        /**
        * Returns the melting point.
        * @return 1795
        */
        public double meltingPoint() {return 1795;}
        /**
        * Returns the boiling point.
        * @return 3136
        */
        public double boilingPoint() {return 3136;}
        /**
        * Returns the density (293K).
        * @return 9.05
        */
        public double density() {return 9.05;}
        /**
        * Returns the specific heat.
        * @return 0.17
        */
        public double specificHeat() {return 0.17;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0117e6
        */
        public double electricalConductivity() {return 0.0117e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.143
        */
        public double thermalConductivity() {return 0.143;}
        /**
        * Returns the chemical symbol.
        * @return Er
        */
        public String toString() {
                return new String("Er");
        }
}
