package JSci.chemistry.periodictable;

/**
* A class representing fluorine.
* @version 1.5
* @author Mark Hale
*/
public final class Fluorine extends Halogen {
        /**
        * Constructs fluorine.
        */
        public Fluorine() {}
        /**
        * Returns the atomic number.
        * @return 9
        */
        public int atomicNumber() {return 9;}
        /**
        * Returns the mass number.
        * @return 19
        */
        public int massNumber() {return 19;}
        /**
        * Returns the electronegativity.
        * @return 3.98
        */
        public double electronegativity() {return 3.98;}
        /**
        * Returns the covalent radius.
        * @return 0.64
        */
        public double covalentRadius() {return 0.64;}
        /**
        * Returns the atomic radius.
        * @return 0.57
        */
        public double atomicRadius() {return 0.57;}
        /**
        * Returns the melting point.
        * @return 53.48
        */
        public double meltingPoint() {return 53.48;}
        /**
        * Returns the boiling point.
        * @return 84.95
        */
        public double boilingPoint() {return 84.95;}
        /**
        * Returns the density (293K).
        * @return 0.001696
        */
        public double density() {return 0.001696;}
        /**
        * Returns the specific heat.
        * @return 0.82
        */
        public double specificHeat() {return 0.82;}
        /**
        * Returns the electrical conductivity.
        * @return 0.0
        */
        public double electricalConductivity() {return 0.0;}
        /**
        * Returns the thermal conductivity.
        * @return 0.000279
        */
        public double thermalConductivity() {return 0.000279;}
        /**
        * Returns the chemical symbol.
        * @return F
        */
        public String toString() {
                return new String("F");
        }
}

