package JSci.chemistry.periodictable;

/**
* A class representing gadolinium.
* @version 1.5
* @author Mark Hale
*/
public final class Gadolinium extends RareEarthMetal {
        /**
        * Constructs gadolinium.
        */
        public Gadolinium() {}
        /**
        * Returns the atomic number.
        * @return 64
        */
        public int atomicNumber() {return 64;}
        /**
        * Returns the mass number.
        * @return 157
        */
        public int massNumber() {return 157;}
        /**
        * Returns the electronegativity.
        * @return 1.20
        */
        public double electronegativity() {return 1.20;}
        /**
        * Returns the covalent radius.
        * @return 1.61
        */
        public double covalentRadius() {return 1.61;}
        /**
        * Returns the atomic radius.
        * @return 2.54
        */
        public double atomicRadius() {return 2.54;}
        /**
        * Returns the melting point.
        * @return 1585
        */
        public double meltingPoint() {return 1585;}
        /**
        * Returns the boiling point.
        * @return 3539
        */
        public double boilingPoint() {return 3539;}
        /**
        * Returns the density (293K).
        * @return 7.895
        */
        public double density() {return 7.895;}
        /**
        * Returns the specific heat.
        * @return 0.23
        */
        public double specificHeat() {return 0.23;}
        /**
        * Returns the electrical conductivity.
        * @return 0.00736e6
        */
        public double electricalConductivity() {return 0.00736e6;}
        /**
        * Returns the thermal conductivity.
        * @return 0.106
        */
        public double thermalConductivity() {return 0.106;}
        /**
        * Returns the chemical symbol.
        * @return Gd
        */
        public String toString() {
                return new String("Gd");
        }
}

